/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S5863")
public class AssertionCompareToSelfCheck
extends PhpUnitCheck {
    private static final String MESSAGE = "Replace this assertion to not have the same actual and expected expression.";

    @Override
    protected void visitPhpUnitAssertion(FunctionCallTree tree, PhpUnitCheck.Assertion assertion) {
        if (assertion.hasExpectedValue() && this.compareToSelf(tree.callArguments())) {
            SeparatedList<CallArgumentTree> args = tree.callArguments();
            this.newIssue(((CallArgumentTree)args.get(1)).value(), MESSAGE).secondary(((CallArgumentTree)args.get(0)).value(), null);
        }
    }

    private boolean compareToSelf(List<CallArgumentTree> args) {
        if (args.size() >= 2) {
            Symbol expectedSymbol = this.getSymbol(args.get(0).value());
            return expectedSymbol != null && expectedSymbol.equals(this.getSymbol(args.get(1).value()));
        }
        return false;
    }

    private Symbol getSymbol(ExpressionTree tree) {
        return this.context().symbolTable().getSymbol(tree);
    }
}

