/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.symbols.FunctionSymbol;
import org.sonar.php.symbols.MethodSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S3699")
public class UseOfEmptyReturnValueCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Remove this use of the output from \"%1$s\"; \"%1$s\" doesn't return anything.";
    private static final String SECONDARY_MESSAGE = "Function definition.";
    private static final Set<String> VOID_FUNCTIONS = CheckUtils.lowerCaseSet("__halt_compiler", "apd_clunk", "apd_croak", "apd_dump_function_table", "apd_set_session", "apd_set_session_trace", "clearstatcache", "closedir", "counter_bump", "counter_bump_value", "counter_reset", "counter_reset_value", "curl_close", "curl_multi_close", "curl_reset", "curl_share_close", "cyrus_authenticate", "dba_close", "debug_print_backtrace", "debug_zval_dump", "define_syslog_variables", "dio_close", "echo", "eio_cancel", "eio_grp_add", "eio_grp_cancel", "eio_grp_limit", "eio_init", "eio_set_max_idle", "eio_set_max_parallel", "eio_set_max_poll_reqs", "eio_set_max_poll_time", "eio_set_min_parallel", "enchant_dict_add_to_session", "error_clear_last", "event_base_free", "event_buffer_fd_set", "event_buffer_free", "event_buffer_timeout_set", "event_buffer_watermark_set", "event_free", "eventutil::sslrandpoll", "exit", "fam_close", "fann_print_error", "fann_reset_errno", "fann_reset_errstr", "fann_set_error_log", "fbsql_set_characterset", "fbsql_set_transaction", "fdf_close", "fdf_header", "flush", "gc_disable", "gc_enable", "geoip_setup_custom_directory", "gnupg_seterrormode", "gupnp_context_set_subscription_timeout", "header", "header_remove", "ibase_blob_add", "imagecolorset", "imagepalettecopy", "imagick::setregistry", "ini_restore", "intlchar::enumcharnames", "intlchar::enumchartypes", "libxml_clear_errors", "libxml_set_external_entity_loader", "libxml_set_streams_context", "m_destroyengine", "mailparse_msg_extract_part", "maxdb_debug", "maxdb_free_result", "maxdb_server_end", "maxdb_stmt_free_result", "ming_setcubicthreshold", "ming_setscale", "ming_setswfcompression", "ming_useconstants", "ming_useswfversion", "mongodb\\driver\\monitoring\\addsubscriber", "mongodb\\driver\\monitoring\\addsubscriber", "mongolog::setlevel", "mongolog::setmodule", "mqseries_back", "mqseries_begin", "mqseries_close", "mqseries_cmit", "mqseries_conn", "mqseries_connx", "mqseries_disc", "mqseries_get", "mqseries_inq", "mqseries_open", "mqseries_put", "mqseries_put1", "mqseries_set", "msession_disconnect", "msession_set_array", "mssql_min_error_severity", "mssql_min_message_severity", "mt_srand", "mysqli_embedded_server_end", "mysqli_free_result", "mysqli_set_local_infile_default", "mysqli_stmt_data_seek", "mysqli_stmt_free_result", "newt_bell", "ob_clean", "ob_flush", "ob_implicit_flush", "oci_internal_debug", "odbc_close", "odbc_close_all", "openssl_free_key", "openssl_pkey_free", "openssl_x509_free", "parse_str", "passthru", "readline_callback_read_char", "readline_on_new_line", "readline_redisplay", "register_shutdown_function", "restore_include_path", "rewinddir", "rrdc_disconnect", "session_abort", "session_register_shutdown", "session_reset", "session_set_cookie_params", "session_unset", "session_write_close", "setproctitle", "shmop_close", "snmp_set_oid_numeric_print", "socket_clear_error", "socket_close", "spl_autoload", "spl_autoload_call", "sqlite_busy_timeout", "sqlite_close", "sqlite_create_aggregate", "sqlite_create_function", "srand", "stats_rand_setall", "stomp_set_read_timeout", "stream_bucket_append", "stream_bucket_prepend", "svn_auth_set_parameter", "sybase_deadlock_retry_count", "sybase_min_client_severity", "sybase_min_error_severity", "sybase_min_message_severity", "sybase_min_server_severity", "tidy_load_config", "trader_set_compat", "trader_set_unstable_period", "ui\\quit", "ui\\run", "unregister_tick_function", "unset", "usleep", "var_dump", "variant_set", "variant_set_type", "xhprof_enable", "xhprof_sample_enable", "zip_close");

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.getFunctionName(tree);
        FunctionSymbol functionSymbol = Symbols.get(tree);
        if (UseOfEmptyReturnValueCheck.parentUseValue(tree) && (UseOfEmptyReturnValueCheck.isVoidBuiltin(functionName) || UseOfEmptyReturnValueCheck.isVoidSymbol(functionSymbol))) {
            PreciseIssue issue = this.context().newIssue(this, tree.callee(), String.format(MESSAGE, functionName));
            if (functionSymbol != null) {
                issue.secondary(functionSymbol.location(), SECONDARY_MESSAGE);
            }
        }
        super.visitFunctionCall(tree);
    }

    private static boolean isVoidBuiltin(@Nullable String functionName) {
        return functionName != null && VOID_FUNCTIONS.contains(functionName.toLowerCase(Locale.ROOT));
    }

    private static boolean isVoidSymbol(FunctionSymbol functionSymbol) {
        return !functionSymbol.isUnknownSymbol() && !functionSymbol.hasReturn() && UseOfEmptyReturnValueCheck.isNotAbstractMethod(functionSymbol) && UseOfEmptyReturnValueCheck.isReturnTypeNotDeclaredOrVoid(functionSymbol);
    }

    private static boolean isNotAbstractMethod(FunctionSymbol functionSymbol) {
        MethodSymbol methodSymbol;
        return !(functionSymbol instanceof MethodSymbol) || (methodSymbol = (MethodSymbol)functionSymbol).isAbstract().isFalse();
    }

    private static boolean isReturnTypeNotDeclaredOrVoid(FunctionSymbol functionSymbol) {
        return !functionSymbol.returnType().isPresent() || functionSymbol.returnType().isVoid();
    }

    private static boolean parentUseValue(Tree child) {
        Tree parent = child.getParent();
        Objects.requireNonNull(parent);
        if (parent.is(Tree.Kind.NEW_EXPRESSION, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.ARROW_FUNCTION_EXPRESSION)) {
            return false;
        }
        if (parent.is(Tree.Kind.PARENTHESISED_EXPRESSION, Tree.Kind.ERROR_CONTROL, Tree.Kind.MATCH_CONDITION_CLAUSE, Tree.Kind.MATCH_DEFAULT_CLAUSE, Tree.Kind.MATCH_EXPRESSION)) {
            return UseOfEmptyReturnValueCheck.parentUseValue(parent);
        }
        if (parent.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.ALTERNATIVE_CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.ALTERNATIVE_CONDITIONAL_OR)) {
            return child == ((BinaryExpressionTree)parent).leftOperand() || UseOfEmptyReturnValueCheck.parentUseValue(parent);
        }
        if (parent.is(Tree.Kind.CONDITIONAL_EXPRESSION)) {
            return child == ((ConditionalExpressionTree)parent).condition() || UseOfEmptyReturnValueCheck.parentUseValue(parent);
        }
        if (parent.is(Tree.Kind.FOR_STATEMENT)) {
            SeparatedList<ExpressionTree> conditions = ((ForStatementTree)parent).condition();
            ExpressionTree lastCondition = conditions.isEmpty() ? null : (ExpressionTree)conditions.get(conditions.size() - 1);
            return child.equals(lastCondition);
        }
        return true;
    }
}

