/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.RegexUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1192")
public class StringLiteralDuplicatedCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Define a constant instead of duplicating this literal \"%s\" %s times.";
    private static final String SECONDARY_MESSAGE = "Duplication.";
    private static final String ONLY_ALPHANUMERIC_UNDERSCORES_HYPHENS_AND_PERIODS = "^[a-zA-Z_][.:,|\\-\\w]+$";
    private static final String IDENTIFIER = "[a-zA-Z][a-zA-Z0-9\\-_:.]*+";
    private static final String OPT_SPACING = "\\s*+";
    private static final String OPT_TEXT_OUTSIDE_OF_TAGS = "[^<>]*+";
    private static final String DOUBLE_QUOTED_STRING = "\"(?:\\\\.|[^\"])*+\"";
    private static final String SINGLE_QUOTED_STRING = "'(?:\\\\.|[^'])*+'";
    private static final String NO_QUOTED_STRING = "[a-zA-Z0-9\\-_:./]++";
    private static final String DOUBLE_QUOTED_STRING_PARTIAL_START = "\"(?:\\\\.|[^\"])*+";
    private static final String SINGLE_QUOTED_STRING_PARTIAL_START = "'(?:\\\\.|[^'])*+";
    private static final String NO_QUOTED_STRING_PARTIAL_START = "[a-zA-Z0-9\\-_:./]++";
    private static final String TAG_ATTRIBUTE_PARTIAL_START = "\\s*+" + RegexUtils.optional("=", "\\s*+", RegexUtils.optional(RegexUtils.firstOf("\"(?:\\\\.|[^\"])*+", "'(?:\\\\.|[^'])*+", "[a-zA-Z0-9\\-_:./]++")));
    private static final String TAG_ATTRIBUTE = "[a-zA-Z][a-zA-Z0-9\\-_:.]*+\\s*+" + RegexUtils.optional("=", "\\s*+", RegexUtils.firstOf("\"(?:\\\\.|[^\"])*+\"", "'(?:\\\\.|[^'])*+'", "[a-zA-Z0-9\\-_:./]++"));
    private static final String HTML_TAG_FULL = "</?\\s*+[a-zA-Z][a-zA-Z0-9\\-_:.]*+\\s*+" + RegexUtils.zeroOrMore(TAG_ATTRIBUTE, "\\s*+") + "/?+>";
    private static final String HTML_TAG_PARTIAL_START = "\\s*+</?+\\s*+" + RegexUtils.optional("[a-zA-Z][a-zA-Z0-9\\-_:.]*+", "\\s*+", RegexUtils.zeroOrMore(TAG_ATTRIBUTE, "\\s*+"), RegexUtils.optional(TAG_ATTRIBUTE_PARTIAL_START));
    private static final String HTML_TAG_PARTIAL_END = "[\"']?+\\s*+" + RegexUtils.zeroOrMore(TAG_ATTRIBUTE, "\\s*+") + "/?+>";
    private static final String HTML_CONTENT = RegexUtils.optional(HTML_TAG_PARTIAL_END) + RegexUtils.oneOrMore("[^<>]*+", HTML_TAG_FULL) + "[^<>]*+" + RegexUtils.optional(HTML_TAG_PARTIAL_START);
    private static final String FULL_ALLOWED_LITERALS_REGEX = RegexUtils.firstOf(HTML_CONTENT, "[^<>]*+" + HTML_TAG_PARTIAL_START, HTML_TAG_PARTIAL_END + "[^<>]*+", HTML_TAG_PARTIAL_END + "[^<>]*+" + HTML_TAG_PARTIAL_START, "^[a-zA-Z_][.:,|\\-\\w]+$");
    private static final Pattern ALLOWED_DUPLICATED_LITERALS = Pattern.compile(FULL_ALLOWED_LITERALS_REGEX);
    public static final int THRESHOLD_DEFAULT = 3;
    public static final int MINIMAL_LITERAL_LENGTH_DEFAULT = 5;
    private final Map<String, LiteralTree> firstOccurrenceTrees = new HashMap<String, LiteralTree>();
    private final Map<String, List<LiteralTree>> sameLiteralOccurrences = new HashMap<String, List<LiteralTree>>();
    @RuleProperty(key="threshold", defaultValue="3")
    int threshold = 3;
    @RuleProperty(key="minimal_literal_length", defaultValue="5")
    int minimalLiteralLength = 5;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        if ("importmap.php".equals(this.context().getPhpFile().filename())) {
            return;
        }
        this.firstOccurrenceTrees.clear();
        this.sameLiteralOccurrences.clear();
        super.visitCompilationUnit(tree);
        this.finish();
    }

    private void finish() {
        for (Map.Entry<String, List<LiteralTree>> literalOccurrences : this.sameLiteralOccurrences.entrySet()) {
            String value = literalOccurrences.getKey();
            List<LiteralTree> occurrences = literalOccurrences.getValue();
            if (occurrences.size() < this.threshold || ALLOWED_DUPLICATED_LITERALS.matcher(value).matches()) continue;
            String literal = literalOccurrences.getKey();
            String message = String.format(MESSAGE, literal, occurrences.size());
            LiteralTree firstOccurrenceTree = this.firstOccurrenceTrees.get(literal);
            PreciseIssue issue = this.context().newIssue(this, firstOccurrenceTree, message).cost(occurrences.size());
            occurrences.stream().filter(o -> !o.equals(firstOccurrenceTree)).forEach(occurrence -> issue.secondary((Tree)occurrence, SECONDARY_MESSAGE));
        }
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        String literal;
        String value;
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL) && !StringLiteralDuplicatedCheck.isArrayKey(tree) && (value = StringLiteralDuplicatedCheck.removeQuotesAndQuotesEscaping(literal = tree.value().replace("\\'", "'").replace("\\\"", "\""))).length() >= this.minimalLiteralLength) {
            if (!this.sameLiteralOccurrences.containsKey(value)) {
                ArrayList<LiteralTree> occurrences = new ArrayList<LiteralTree>();
                occurrences.add(tree);
                this.sameLiteralOccurrences.put(value, occurrences);
                this.firstOccurrenceTrees.put(value, tree);
            } else {
                this.sameLiteralOccurrences.get(value).add(tree);
            }
        }
    }

    private static String removeQuotesAndQuotesEscaping(String s) {
        char quote = s.charAt(0);
        return s.substring(1, s.length() - 1).replace("\\" + quote, String.valueOf(quote));
    }

    private static boolean isArrayKey(LiteralTree tree) {
        Tree parent = tree.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.is(Tree.Kind.ARRAY_PAIR)) {
            ArrayPairTree arrayPair = (ArrayPairTree)parent;
            return tree.equals(arrayPair.key());
        }
        if (parent.is(Tree.Kind.ARRAY_ACCESS)) {
            ArrayAccessTree arrayAccess = (ArrayAccessTree)parent;
            return tree.equals(arrayAccess.offset());
        }
        return false;
    }
}

