/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Locale;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S4833")
public class RequireIncludeInstructionsUsageCheck
extends PHPVisitorCheck {
    public static final String KEY = "S4833";
    private static final String MESSAGE = "Replace \"%s\" with namespace import mechanism through the \"use\" keyword.";
    private static final Set<String> EXCLUDED_FILES = Set.of("autoload.php", "ScriptHandler.php");
    private static final Set<String> WRONG_FUNCTIONS = Set.of("require", "include", "require_once", "include_once");

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (!this.isExcludedFile()) {
            super.visitCompilationUnit(tree);
        }
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        super.visitFunctionCall(tree);
        String callee = tree.callee().toString();
        if (!this.isLaravelFrameworkUsed() && WRONG_FUNCTIONS.contains(callee.toLowerCase(Locale.ENGLISH)) && !RequireIncludeInstructionsUsageCheck.isAutoloadImport(tree)) {
            String message = String.format(MESSAGE, callee);
            this.context().newIssue(this, tree.callee(), message);
        }
    }

    private boolean isExcludedFile() {
        String filename = this.context().getPhpFile().filename();
        return EXCLUDED_FILES.contains(filename);
    }

    private static boolean isAutoloadImport(FunctionCallTree tree) {
        String call = tree.toString();
        return (call.startsWith("include") || call.startsWith("require")) && call.endsWith("autoload.php'");
    }

    private boolean isLaravelFrameworkUsed() {
        return this.context().getFramework() == SymbolTable.Framework.LARAVEL;
    }
}

