/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S122")
public class OneStatementPerLineCheck
extends PHPSubscriptionCheck {
    private static final String MESSAGE = "%s %s were found on this line. Reformat the code to have only one %s per line.";
    private final Map<Integer, StatementCount> statementsPerLine = new HashMap<Integer, StatementCount>();
    private final Set<Integer> linesWithHtml = new HashSet<Integer>();
    private boolean inFunctionExpression = false;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.SCRIPT, Tree.Kind.DECLARE_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.ALTERNATIVE_IF_STATEMENT, Tree.Kind.FOREACH_STATEMENT, Tree.Kind.ALTERNATIVE_FOREACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.ALTERNATIVE_FOR_STATEMENT, Tree.Kind.NAMESPACE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.CLASS_DECLARATION, Tree.Kind.TRAIT_DECLARATION, Tree.Kind.INTERFACE_DECLARATION, Tree.Kind.CONSTANT_DECLARATION, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GLOBAL_STATEMENT, Tree.Kind.GOTO_STATEMENT, Tree.Kind.INLINE_HTML_TOKEN, Tree.Kind.RETURN_STATEMENT, Tree.Kind.STATIC_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.UNSET_VARIABLE_STATEMENT, Tree.Kind.USE_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.SCRIPT)) {
            this.statementsPerLine.clear();
            this.linesWithHtml.clear();
            this.inFunctionExpression = false;
            return;
        }
        int line = OneStatementPerLineCheck.line(tree);
        if (tree.is(Tree.Kind.INLINE_HTML_TOKEN)) {
            this.linesWithHtml.add(line);
        } else if (tree.is(Tree.Kind.FUNCTION_EXPRESSION)) {
            if (this.statementsPerLine.containsKey(line)) {
                ++this.statementsPerLine.get((Object)Integer.valueOf((int)line)).nbFunctionExpression;
                this.inFunctionExpression = true;
            }
        } else {
            if (!this.statementsPerLine.containsKey(line)) {
                this.statementsPerLine.put(line, new StatementCount());
            } else if (this.inFunctionExpression) {
                ++this.statementsPerLine.get((Object)Integer.valueOf((int)line)).nbNestedStatement;
            }
            if (!this.inFunctionExpression) {
                ++this.statementsPerLine.get((Object)Integer.valueOf((int)line)).nbStatement;
            }
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.FUNCTION_EXPRESSION) && this.statementsPerLine.containsKey(OneStatementPerLineCheck.line(tree))) {
            this.inFunctionExpression = false;
        }
        if (tree.is(Tree.Kind.SCRIPT)) {
            this.finish();
        }
    }

    private void finish() {
        for (Map.Entry<Integer, StatementCount> statementsAtLine : this.statementsPerLine.entrySet()) {
            Integer line = statementsAtLine.getKey();
            if (this.linesWithHtml.contains(line)) continue;
            StatementCount stmtCount = statementsAtLine.getValue();
            if (stmtCount.nbStatement > 1 || stmtCount.nbNestedStatement > 1) {
                this.reportIssue(line, stmtCount.nbStatement + stmtCount.nbNestedStatement, "statement");
                continue;
            }
            if (stmtCount.nbFunctionExpression <= 1) continue;
            this.reportIssue(line, stmtCount.nbFunctionExpression, "function expression");
        }
    }

    private void reportIssue(int line, int actualCount, String name) {
        this.context().newLineIssue(this, line, MESSAGE.formatted(actualCount, name + "s", name));
    }

    private static int line(Tree tree) {
        return ((PHPTree)tree).getLine();
    }

    private static class StatementCount {
        int nbStatement = 0;
        int nbFunctionExpression = 0;
        int nbNestedStatement = 0;

        private StatementCount() {
        }
    }
}

