/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S2277")
public class NoPaddingRsaCheck
extends FunctionUsageCheck {
    public static final String KEY = "S2277";
    private static final String MESSAGE = "Use an RSA algorithm with a OAEP padding: OPENSSL_PKCS1_OAEP_PADDING.";
    private static final int PADDING_ARGUMENT_INDEX = 3;
    private static final String SECURE_PADDING = "OPENSSL_PKCS1_OAEP_PADDING";

    @Override
    protected Set<String> lookedUpFunctionNames() {
        return Set.of("openssl_public_encrypt");
    }

    @Override
    protected void checkFunctionCall(FunctionCallTree tree) {
        Optional<CallArgumentTree> paddingArgument = CheckUtils.argument(tree, "padding", 3);
        if (paddingArgument.isPresent()) {
            ExpressionTree padding = paddingArgument.get().value();
            if (padding.is(Tree.Kind.NAMESPACE_NAME) && !((NamespaceNameTree)padding).unqualifiedName().equals(SECURE_PADDING)) {
                this.context().newIssue(this, padding, MESSAGE);
            }
        } else {
            this.context().newIssue(this, tree.callee(), MESSAGE);
        }
    }
}

