/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.AbstractStatementsCheck;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S2681")
public class MultilineBlocksCurlyBracesCheck
extends AbstractStatementsCheck {
    public static final String KEY = "S2681";
    private static final String MESSAGE_LOOP = "This statement will not be executed in a loop; only the first statement of this %s-statement block will be. The rest will execute only once.";
    private static final String MESSAGE_IF = "This statement will not be executed conditionally; only the first statement of this %s-statement block will be. The rest will execute unconditionally.";

    @Override
    public void visitNode(Tree tree) {
        List<StatementTree> statements = MultilineBlocksCurlyBracesCheck.getStatements(tree);
        for (int i = 0; i < statements.size() - 1; ++i) {
            StatementTree forStatement;
            StatementTree currentStatement = statements.get(i);
            if (currentStatement.is(Tree.Kind.IF_STATEMENT)) {
                IfStatementTree ifStatement = (IfStatementTree)currentStatement;
                this.checkStatement(ifStatement.ifToken(), ifStatement.condition(), MultilineBlocksCurlyBracesCheck.getLastStatementOfIf(ifStatement), i, statements);
                continue;
            }
            if (currentStatement.is(Tree.Kind.FOR_STATEMENT)) {
                forStatement = (ForStatementTree)currentStatement;
                this.checkStatement(forStatement.forToken(), forStatement.closeParenthesisToken(), forStatement.statements().get(0), i, statements);
                continue;
            }
            if (currentStatement.is(Tree.Kind.FOREACH_STATEMENT)) {
                forStatement = (ForEachStatementTree)currentStatement;
                this.checkStatement(forStatement.foreachToken(), forStatement.closeParenthesisToken(), forStatement.statements().get(0), i, statements);
                continue;
            }
            if (!currentStatement.is(Tree.Kind.WHILE_STATEMENT)) continue;
            WhileStatementTree whileStatement = (WhileStatementTree)currentStatement;
            this.checkStatement(whileStatement.whileToken(), whileStatement.condition(), whileStatement.statements().get(0), i, statements);
        }
    }

    private static StatementTree getLastStatementOfIf(StatementTree statement) {
        if (!statement.is(Tree.Kind.IF_STATEMENT)) {
            return statement;
        }
        IfStatementTree ifStatement = (IfStatementTree)statement;
        ElseClauseTree elseClause = ifStatement.elseClause();
        List<ElseifClauseTree> elseifClause = ifStatement.elseifClauses();
        List<StatementTree> childStatements = elseClause != null ? elseClause.statements() : (!elseifClause.isEmpty() ? elseifClause.get(elseifClause.size() - 1).statements() : ifStatement.statements());
        return MultilineBlocksCurlyBracesCheck.getLastStatementOfIf(childStatements.get(childStatements.size() - 1));
    }

    private void checkStatement(Tree parentStart, Tree parentEnd, StatementTree firstInnerStatement, int nestingStatementNum, List<StatementTree> statements) {
        if (firstInnerStatement.is(Tree.Kind.BLOCK)) {
            return;
        }
        int parentLine = MultilineBlocksCurlyBracesCheck.lastTokenLine(parentEnd);
        int parentColumn = MultilineBlocksCurlyBracesCheck.column(parentStart);
        StatementBlock statementBlock = MultilineBlocksCurlyBracesCheck.findBlock(parentLine, parentColumn, firstInnerStatement, nestingStatementNum, statements);
        if (!statementBlock.otherStatement.isEmpty()) {
            boolean isIfStatement = statements.get(nestingStatementNum).is(Tree.Kind.IF_STATEMENT);
            String message = String.format(isIfStatement ? MESSAGE_IF : MESSAGE_LOOP, statementBlock.size());
            PreciseIssue issue = this.context().newIssue(this, statementBlock.otherStatement.get(0), message);
            issue.secondary(firstInnerStatement, isIfStatement ? "Executed conditionally" : "Executed in a loop");
            String secondaryMessage = isIfStatement ? "Always executed" : "Executed once";
            statementBlock.otherStatement.stream().skip(1L).forEach(statement -> issue.secondary((Tree)statement, secondaryMessage));
        }
    }

    private static StatementBlock findBlock(int parentLine, int parentColumn, StatementTree firstInnerStatement, int nestingStatementNum, List<StatementTree> statements) {
        StatementTree statement;
        StatementBlock statementBlock = new StatementBlock(firstInnerStatement, parentColumn, parentLine);
        for (int i = nestingStatementNum + 1; i < statements.size() && statementBlock.add(statement = statements.get(i)); ++i) {
        }
        return statementBlock;
    }

    private static int column(Tree tree) {
        return ((PHPTree)tree).getFirstToken().column();
    }

    private static int lastTokenLine(Tree tree) {
        return ((PHPTree)tree).getLastToken().line();
    }

    private static class StatementBlock {
        static final int MAX_STATEMENT_DISTANCE_IN_THE_SAME_BLOCK = 4;
        final StatementTree firstStatement;
        final List<StatementTree> otherStatement = new ArrayList<StatementTree>();
        final int parentMarginColumn;
        int lastStatementLine;
        int lastStatementColumn;
        boolean firstStatementOneLiner;

        StatementBlock(StatementTree firstStatement, int parentMarginColumn, int parentLastLine) {
            this.firstStatement = firstStatement;
            this.lastStatementLine = StatementBlock.line(firstStatement);
            this.firstStatementOneLiner = this.lastStatementLine == parentLastLine;
            this.lastStatementColumn = MultilineBlocksCurlyBracesCheck.column(firstStatement);
            this.parentMarginColumn = parentMarginColumn;
        }

        int size() {
            return 1 + this.otherStatement.size();
        }

        boolean add(StatementTree statement) {
            if (statement.is(Tree.Kind.INLINE_HTML)) {
                return true;
            }
            int line = StatementBlock.line(statement);
            int column = MultilineBlocksCurlyBracesCheck.column(statement);
            if (column < this.parentMarginColumn || !this.isLineCloseToPreviousStatement(line)) {
                return false;
            }
            if (column == this.parentMarginColumn && (this.firstStatementOneLiner || column != this.lastStatementColumn || !this.isOneLineAfterPreviousStatement(line))) {
                return false;
            }
            this.otherStatement.add(statement);
            this.lastStatementLine = line;
            this.lastStatementColumn = column;
            return true;
        }

        private boolean isLineCloseToPreviousStatement(int line) {
            return line < this.lastStatementLine + 4;
        }

        private boolean isOneLineAfterPreviousStatement(int line) {
            return line == this.lastStatementLine + 1;
        }

        private static int line(Tree tree) {
            return ((PHPTree)tree).getFirstToken().line();
        }
    }
}

