/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S117")
public class LocalVariableAndParameterNameCheck
extends PHPSubscriptionCheck {
    private static final String MESSAGE = "Rename this %s \"%s\" to match the regular expression %s.";
    public static final String DEFAULT = "^[a-z_][a-zA-Z0-9_]*$";
    private Deque<Set<String>> checkedVariables = new ArrayDeque<Set<String>>();
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="^[a-z_][a-zA-Z0-9_]*$")
    String format = "^[a-z_][a-zA-Z0-9_]*$";

    @Override
    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ListUtils.concat(CheckUtils.getFunctionKinds(), Arrays.asList(Tree.Kind.ASSIGNMENT_BY_REFERENCE, Tree.Kind.ASSIGNMENT, Tree.Kind.POWER_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.CONCATENATION_ASSIGNMENT));
    }

    @Override
    public void visitNode(Tree tree) {
        if (CheckUtils.isFunction(tree)) {
            this.enterScope();
            this.checkParameters((FunctionTree)tree);
        } else if (this.inScope()) {
            this.checkLocalVariable(tree);
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (CheckUtils.isFunction(tree)) {
            this.leaveScope();
        }
    }

    private void checkLocalVariable(Tree tree) {
        VariableIdentifierTree variableIdentifier;
        String variableName;
        ExpressionTree variable = LocalVariableAndParameterNameCheck.getLeftHandExpression(tree);
        if (variable.is(Tree.Kind.VARIABLE_IDENTIFIER) && !this.isAlreadyChecked(variableName = (variableIdentifier = (VariableIdentifierTree)variable).variableExpression().text()) && !this.isCompliant(variableName)) {
            this.reportIssue("local variable", variable, variableName);
        }
    }

    private void checkParameters(FunctionTree functionDec) {
        for (ParameterTree parameter : functionDec.parameters().parameters()) {
            String paramName = parameter.variableIdentifier().variableExpression().text();
            if (this.isCompliant(paramName)) continue;
            this.reportIssue("parameter", parameter, paramName);
        }
    }

    private void reportIssue(String type, Tree tree, String varName) {
        this.context().newIssue(this, tree, String.format(MESSAGE, type, varName, this.format));
        this.setAsCheckedVariable(varName);
    }

    private static ExpressionTree getLeftHandExpression(Tree assignmentExpr) {
        ExpressionTree leftExpression = ((AssignmentExpressionTree)assignmentExpr).variable();
        while (leftExpression.is(Tree.Kind.ARRAY_ACCESS)) {
            leftExpression = ((ArrayAccessTree)leftExpression).object();
        }
        return leftExpression;
    }

    private boolean isCompliant(String varName) {
        return this.pattern.matcher(varName.replace("$", "")).matches() || LocalVariableAndParameterNameCheck.isSuperGlobal(varName);
    }

    private static boolean isSuperGlobal(String varName) {
        return CheckUtils.SUPERGLOBALS.contains(varName);
    }

    private void setAsCheckedVariable(String varName) {
        this.checkedVariables.peek().add(varName);
    }

    private boolean isAlreadyChecked(String varName) {
        return this.checkedVariables.peek().contains(varName);
    }

    private boolean inScope() {
        return !this.checkedVariables.isEmpty();
    }

    private void enterScope() {
        this.checkedVariables.push(new HashSet());
    }

    private void leaveScope() {
        this.checkedVariables.pop();
    }
}

