/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S110")
public class InheritanceDepthCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "This class has %d parents which is greater than %d authorized.";
    private static final String SECONDARY_MESSAGE = "Parent class.";
    public static final int DEFAULT_MAX = 5;
    @RuleProperty(key="max", description="Maximum depth of the inheritance tree. (Number)", defaultValue="5")
    public int max = 5;
    @RuleProperty(key="filteredClasses", description="Classes to be filtered out of the count of inheritance. Ex : RuntimeException, Exception")
    public String filteredClasses = "";
    private Set<QualifiedName> filteredOutClassNames;
    private int inheritanceCounter = 0;

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        ClassSymbol symbol = Symbols.get(tree);
        this.checkClassInheritance(symbol, tree.name());
        super.visitClassDeclaration(tree);
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        ClassSymbol symbol;
        NamespaceNameTree superClass = tree.superClass();
        if (superClass != null && !(symbol = Symbols.getClass(superClass)).isUnknownSymbol()) {
            this.inheritanceCounter = 1;
            this.checkClassInheritance(symbol, tree.classToken());
        }
        super.visitAnonymousClass(tree);
    }

    private void checkClassInheritance(ClassSymbol symbol, Tree tree) {
        Optional<ClassSymbol> superClass = symbol.superClass();
        HashSet<ClassSymbol> superClasses = new HashSet<ClassSymbol>();
        while (superClass.filter(classSymbol -> !classSymbol.isUnknownSymbol()).isPresent()) {
            ClassSymbol superClassSymbol = superClass.get();
            QualifiedName qualifiedName = superClassSymbol.qualifiedName();
            if (this.getFilteredOutClasses().contains(qualifiedName) || !superClasses.add(superClassSymbol)) break;
            ++this.inheritanceCounter;
            superClass = superClassSymbol.superClass();
        }
        if (this.inheritanceCounter > this.max) {
            PreciseIssue issue = this.newIssue(tree, String.format(MESSAGE, this.inheritanceCounter, this.max)).cost(this.inheritanceCounter - this.max);
            superClasses.forEach(e -> issue.secondary(e.location(), SECONDARY_MESSAGE));
        }
        this.inheritanceCounter = 0;
    }

    private Set<QualifiedName> getFilteredOutClasses() {
        if (this.filteredOutClassNames == null) {
            this.filteredOutClassNames = Arrays.stream(this.filteredClasses.split(",")).map(String::trim).map(QualifiedName::qualifiedName).collect(Collectors.toSet());
        }
        return this.filteredOutClassNames;
    }
}

