/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S881")
public class IncrementDecrementInSubExpressionCheck
extends PHPVisitorCheck {
    public static final String KEY = "S881";
    private static final String MESSAGE = "Extract this increment or decrement operator into a dedicated statement.";
    private static final Tree.Kind[] INC_DEC = new Tree.Kind[]{Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT};

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        if (!tree.expression().is(INC_DEC)) {
            super.visitExpressionStatement(tree);
        }
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.scanExpressionList(tree.init());
        this.scanExpressionList(tree.condition());
        this.scanExpressionList(tree.update());
        this.scan(tree.statements());
    }

    private void scanExpressionList(SeparatedList<ExpressionTree> list) {
        for (ExpressionTree expression : list) {
            if (expression.is(INC_DEC)) {
                this.scan(((UnaryExpressionTree)expression).expression());
                continue;
            }
            this.scan(expression);
        }
    }

    @Override
    public void visitPostfixExpression(UnaryExpressionTree tree) {
        if (tree.is(INC_DEC)) {
            this.raiseIssue(tree);
        }
        super.visitPostfixExpression(tree);
    }

    @Override
    public void visitPrefixExpression(UnaryExpressionTree tree) {
        if (tree.is(INC_DEC)) {
            this.raiseIssue(tree);
        }
        super.visitPrefixExpression(tree);
    }

    private void raiseIssue(Tree tree) {
        this.context().newIssue(this, tree, MESSAGE);
    }
}

