/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.AbstractStatementsCheck;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ArrayAssignmentPatternElementTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ListExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1488")
public class ImmediatelyReturnedVariableCheck
extends AbstractStatementsCheck {
    public static final String KEY = "S1488";
    private static final String MESSAGE = "Immediately %s this expression instead of assigning it to the temporary variable \"%s\".";
    private int level = 0;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ListUtils.concat(CheckUtils.getFunctionKinds(), super.nodesToVisit());
    }

    @Override
    public void visitNode(Tree tree) {
        if (CheckUtils.isFunction(tree)) {
            ++this.level;
        } else if (this.level > 0) {
            this.checkStatements(ImmediatelyReturnedVariableCheck.getStatements(tree));
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (CheckUtils.isFunction(tree)) {
            --this.level;
        }
    }

    private void checkStatements(List<StatementTree> statements) {
        for (int i = 0; i < statements.size() - 1; ++i) {
            StatementTree currentStatement = statements.get(i);
            StatementTree nextStatement = statements.get(i + 1);
            List<String> assignedNames = ImmediatelyReturnedVariableCheck.getAssignedVariablesNames(currentStatement);
            String returnedName = ImmediatelyReturnedVariableCheck.getReturnedOrThrownVariableName(nextStatement);
            if (returnedName == null || !assignedNames.contains(returnedName)) continue;
            ExpressionTree variable = ((AssignmentExpressionTree)((ExpressionStatementTree)currentStatement).expression()).variable();
            this.reportIssue(nextStatement, returnedName, variable);
        }
    }

    private static List<String> getAssignedVariablesNames(StatementTree currentStatement) {
        Tree variable = null;
        ExpressionTree value = null;
        if (currentStatement.is(Tree.Kind.EXPRESSION_STATEMENT)) {
            ExpressionTree expression = ((ExpressionStatementTree)currentStatement).expression();
            if (expression.is(Tree.Kind.ASSIGNMENT, Tree.Kind.ASSIGNMENT_BY_REFERENCE)) {
                variable = ((AssignmentExpressionTree)expression).variable();
                value = ((AssignmentExpressionTree)expression).value();
            }
        }
        ArrayList<String> names = new ArrayList<String>();
        if (variable != null) {
            if (variable.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                names.add(((VariableIdentifierTree)variable).variableExpression().text());
            } else if (variable.is(Tree.Kind.LIST_EXPRESSION)) {
                names.addAll(ImmediatelyReturnedVariableCheck.getVariablesFromList((ListExpressionTree)variable));
            }
            UsedVariablesCollector usedVariablesCollector = new UsedVariablesCollector();
            value.accept(usedVariablesCollector);
            names.removeAll(usedVariablesCollector.usedVariables);
        }
        return names;
    }

    private static List<String> getVariablesFromList(ListExpressionTree listExpressionTree) {
        ArrayList<String> names = new ArrayList<String>();
        for (Optional<ArrayAssignmentPatternElementTree> element : listExpressionTree.elements()) {
            if (!element.isPresent() || !element.get().variable().is(Tree.Kind.VARIABLE_IDENTIFIER)) continue;
            names.add(((VariableIdentifierTree)element.get().variable()).variableExpression().text());
        }
        return names;
    }

    @Nullable
    private static String getReturnedOrThrownVariableName(StatementTree statement) {
        ExpressionTree returnedVariable = null;
        if (statement.is(Tree.Kind.RETURN_STATEMENT)) {
            returnedVariable = ((ReturnStatementTree)statement).expression();
        } else if (statement.is(Tree.Kind.THROW_STATEMENT)) {
            returnedVariable = ((ThrowStatementTree)statement).expression();
        }
        String returnedName = null;
        if (returnedVariable != null && returnedVariable.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            returnedName = ((VariableIdentifierTree)returnedVariable).variableExpression().text();
        }
        return returnedName;
    }

    private void reportIssue(StatementTree nextStatement, String varName, Tree tree) {
        String message = String.format(MESSAGE, nextStatement.is(Tree.Kind.RETURN_STATEMENT) ? "return" : "throw", varName);
        this.context().newIssue(this, tree, message);
    }

    static class UsedVariablesCollector
    extends PHPVisitorCheck {
        private final Set<String> usedVariables = new HashSet<String>();

        UsedVariablesCollector() {
        }

        @Override
        public void visitVariableIdentifier(VariableIdentifierTree tree) {
            this.usedVariables.add(tree.variableExpression().text());
            super.visitVariableIdentifier(tree);
        }
    }
}

