/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S100")
public class FunctionNameCheck
extends PHPVisitorCheck {
    public static final String KEY = "S100";
    private static final String MESSAGE = "Rename function \"%s\" to match the regular expression %s.";
    public static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    public static final String FORMAT_DRUPAL_AND_WORDPRESS = "^[a-z][a-z0-9_]*$";
    private static final Pattern PATTERN_DRUPAL_AND_WORDPRESS = Pattern.compile("^[a-z][a-z0-9_]*$");
    private Pattern pattern = null;
    boolean wasDefaultOverridden = false;
    @RuleProperty(key="format", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";

    @Override
    public void init() {
        this.pattern = Pattern.compile(this.format);
        this.wasDefaultOverridden = !this.format.equals(DEFAULT);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (Symbols.get(tree).isOverriding().isFalse()) {
            this.check(tree.name());
        }
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.check(tree.name());
        super.visitFunctionDeclaration(tree);
    }

    private void check(NameIdentifierTree name) {
        String functionName = name.text();
        if (!this.getPattern().matcher(functionName).matches() && !CheckUtils.MAGIC_METHODS.contains(functionName)) {
            this.context().newIssue(this, name, String.format(MESSAGE, functionName, this.getFormat()));
        }
    }

    private Pattern getPattern() {
        if (this.isFrameworkDrupalOrWordpress() && !this.wasDefaultOverridden) {
            return PATTERN_DRUPAL_AND_WORDPRESS;
        }
        return this.pattern;
    }

    private String getFormat() {
        if (this.isFrameworkDrupalOrWordpress() && !this.wasDefaultOverridden) {
            return FORMAT_DRUPAL_AND_WORDPRESS;
        }
        return this.format;
    }

    private boolean isFrameworkDrupalOrWordpress() {
        return this.context().isFramework(SymbolTable.Framework.DRUPAL) || this.context().isFramework(SymbolTable.Framework.WORDPRESS);
    }
}

