/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1793")
public class ElseIfSequenceKeywordUsageCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1793";
    private static final String MESSAGE = "Replace this \"else if\" keyword sequence by \"elseif\" keyword.";

    @Override
    public void visitElseClause(ElseClauseTree tree) {
        if (!tree.is(Tree.Kind.ALTERNATIVE_ELSE_CLAUSE) && ElseIfSequenceKeywordUsageCheck.isElseIf(tree)) {
            this.context().newIssue(this, tree.elseToken(), ((IfStatementTree)tree.statements().get(0)).ifToken(), MESSAGE);
        }
        super.visitElseClause(tree);
    }

    private static boolean isElseIf(ElseClauseTree elseClause) {
        return !elseClause.statements().isEmpty() && elseClause.statements().get(0).is(Tree.Kind.IF_STATEMENT);
    }
}

