/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.php.tree.TreeUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2830")
public class ConstructorDependencyInversionCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2830";
    private static final String MESSAGE = "Remove this creation of object in constructor. Use dependency injection instead.";
    private Deque<Boolean> inConstructor = new ArrayDeque<Boolean>();

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.visitClass(tree);
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.visitClass(tree);
    }

    private void visitClass(ClassTree tree) {
        this.inConstructor.addLast(false);
        MethodDeclarationTree constructor = tree.fetchConstructor();
        for (ClassMemberTree memberTree : tree.members()) {
            if (memberTree.equals(constructor)) {
                this.inConstructor.addLast(true);
                this.scan(memberTree);
                this.inConstructor.removeLast();
                this.inConstructor.addLast(false);
                continue;
            }
            this.scan(memberTree);
        }
        this.inConstructor.removeLast();
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
    }

    @Override
    public void visitNewExpression(NewExpressionTree tree) {
        if (!this.inConstructor.isEmpty() && this.inConstructor.getLast().booleanValue() && !ConstructorDependencyInversionCheck.isInParameterDefault(tree)) {
            this.context().newIssue(this, tree.newToken(), MESSAGE);
        }
        super.visitNewExpression(tree);
    }

    private static boolean isInParameterDefault(NewExpressionTree newExpr) {
        return TreeUtils.findAncestorWithKind((Tree)newExpr, Tree.Kind.PARAMETER) != null;
    }
}

