/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.DeclaredTypeTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.declaration.TypeTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1200")
public class ClassCouplingCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Split this class into smaller and more specialized ones to reduce its dependencies on other classes from %s to the maximum authorized %s or less.";
    private static final String SECONDARY_MESSAGE = "Dependency on %s.";
    public static final int DEFAULT = 20;
    private final Deque<Map<String, Tree>> types = new ArrayDeque<Map<String, Tree>>();
    private static final Set<String> DOC_TAGS = Set.of("@var", "@global", "@staticvar", "@throws", "@param", "@return");
    private static final Set<String> EXCLUDED_TYPES = Set.of("integer", "int", "double", "float", "string", "array", "object", "boolean", "bool", "binary", "null", "mixed");
    @RuleProperty(key="max", defaultValue="20")
    public int max = 20;

    @Override
    public void visitNewExpression(NewExpressionTree tree) {
        this.retrieveInstantiatedClassName(tree);
        super.visitNewExpression(tree);
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        if (tree.is(Tree.Kind.CLASS_DECLARATION)) {
            this.enterClass(tree);
        }
        super.visitClassDeclaration(tree);
        if (tree.is(Tree.Kind.CLASS_DECLARATION)) {
            this.leaveClass(tree);
        }
    }

    private void leaveClass(ClassTree tree) {
        Map<String, Tree> coupledTrees = this.types.removeLast();
        int numberOfTypes = coupledTrees.size();
        if (numberOfTypes > this.max) {
            String message = String.format(MESSAGE, numberOfTypes, this.max);
            PreciseIssue preciseIssue = this.context().newIssue(this, tree.classToken(), message);
            ClassCouplingCheck.raiseSecondaryLocations(preciseIssue, coupledTrees);
        }
    }

    private static void raiseSecondaryLocations(PreciseIssue preciseIssue, Map<String, Tree> coupledTrees) {
        HashMap<Tree, String> treeToNames = new HashMap<Tree, String>();
        for (Map.Entry<String, Tree> entry : coupledTrees.entrySet()) {
            treeToNames.compute(entry.getValue(), (k, oldValue) -> oldValue == null ? (String)nameAndTree.getKey() : oldValue.concat(", " + (String)nameAndTree.getKey()));
        }
        for (Map.Entry<String, Tree> entry : treeToNames.entrySet()) {
            preciseIssue.secondary((Tree)((Object)entry.getKey()), String.format(SECONDARY_MESSAGE, entry.getValue()));
        }
    }

    private void enterClass(ClassTree tree) {
        this.types.addLast(new HashMap());
        this.retrieveCoupledTypes(tree);
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.enterClass(tree);
        super.visitAnonymousClass(tree);
        this.leaveClass(tree);
    }

    private void retrieveCoupledTypes(ClassTree classTree) {
        for (ClassMemberTree classMember : classTree.members()) {
            switch (classMember.getKind()) {
                case CLASS_PROPERTY_DECLARATION: 
                case CLASS_CONSTANT_PROPERTY_DECLARATION: {
                    this.retrieveTypeFromDoc(classMember);
                    break;
                }
                case METHOD_DECLARATION: {
                    this.retrieveTypeFromDoc(classMember);
                    this.retrieveTypeFromParameter((MethodDeclarationTree)classMember);
                    break;
                }
            }
        }
    }

    private void retrieveTypeFromParameter(MethodDeclarationTree methodDeclaration) {
        for (ParameterTree parameter : methodDeclaration.parameters().parameters()) {
            DeclaredTypeTree type = parameter.declaredType();
            if (type == null || !type.isSimple() || !((TypeTree)type).typeName().is(Tree.Kind.NAMESPACE_NAME)) continue;
            this.addType(ClassCouplingCheck.getTypeName((NamespaceNameTree)((TypeTree)type).typeName()), type);
        }
    }

    private void retrieveTypeFromDoc(ClassMemberTree varDeclaration) {
        SyntaxToken varDecToken = ((PHPTree)((Object)varDeclaration)).getFirstToken();
        for (SyntaxTrivia comment : varDecToken.trivias()) {
            for (String line : comment.text().split("[\\n\\r\\u2028\\u2029]++")) {
                this.retrieveTypeFromCommentLine(line, comment);
            }
        }
    }

    private void retrieveTypeFromCommentLine(String line, Tree trivia) {
        String[] commentLine = line.trim().split("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++");
        if (commentLine.length > 2 && DOC_TAGS.contains(commentLine[1])) {
            for (String type : commentLine[2].split("\\|")) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                if (EXCLUDED_TYPES.contains(type.toLowerCase(Locale.ROOT))) continue;
                this.addType(type, trivia);
            }
        }
    }

    private void retrieveInstantiatedClassName(NewExpressionTree newExpression) {
        ExpressionTree expression = newExpression.expression();
        if (expression.is(Tree.Kind.FUNCTION_CALL)) {
            ExpressionTree callee = ((FunctionCallTree)expression).callee();
            if (callee.is(Tree.Kind.NAMESPACE_NAME)) {
                this.addType(ClassCouplingCheck.getTypeName((NamespaceNameTree)callee), callee);
            }
        } else if (expression.is(Tree.Kind.NAMESPACE_NAME)) {
            this.addType(ClassCouplingCheck.getTypeName((NamespaceNameTree)expression), expression);
        }
    }

    private static String getTypeName(NamespaceNameTree namespaceName) {
        String name = namespaceName.fullName();
        String prefix = "namespace\\";
        if (name.toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT))) {
            name = name.substring(prefix.length() - 1);
        }
        return name;
    }

    private void addType(String type, Tree tree) {
        if (!this.types.isEmpty()) {
            this.types.getLast().compute(type, (k, v) -> v == null || v instanceof SyntaxTrivia ? tree : v);
        }
    }
}

