/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Locale;
import java.util.Optional;
import org.sonar.php.checks.CheckBundle;
import org.sonar.php.checks.CheckBundlePart;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class CakePhpDebugModeCheckPart
extends PHPVisitorCheck
implements CheckBundlePart {
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private static final String CONFIG_FUNCTION = "Configure::config".toLowerCase(Locale.ROOT);
    private static final String WRITE_FUNCTION = "Configure::write".toLowerCase(Locale.ROOT);
    private CheckBundle bundle;

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        if (CONFIG_FUNCTION.equals(functionName)) {
            this.checkArgs(tree, "name", "engine");
        } else if (WRITE_FUNCTION.equals(functionName)) {
            this.checkArgs(tree, "config", "value");
        }
        super.visitFunctionCall(tree);
    }

    private void checkArgs(FunctionCallTree tree, String arg1Name, String arg2Name) {
        CallArgumentTree firstArgument = CheckUtils.argument(tree, arg1Name, 0).orElse(null);
        CallArgumentTree secondArgument = CheckUtils.argument(tree, arg2Name, 1).orElse(null);
        if (firstArgument != null && secondArgument != null && firstArgument.value().is(Tree.Kind.REGULAR_STRING_LITERAL) && CheckUtils.trimQuotes((LiteralTree)firstArgument.value()).equals("debug") && CakePhpDebugModeCheckPart.isTrue(secondArgument.value())) {
            this.context().newIssue(this.getBundle(), tree, MESSAGE);
        }
    }

    private static boolean isTrue(ExpressionTree tree) {
        Optional<ExpressionTree> uniqueAssignedValue;
        if (tree.is(Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.REGULAR_STRING_LITERAL) && CheckUtils.isTrueValue(tree)) {
            return true;
        }
        if (tree.is(Tree.Kind.VARIABLE_IDENTIFIER) && (uniqueAssignedValue = CheckUtils.uniqueAssignedValue((VariableIdentifierTree)tree)).isPresent()) {
            ExpressionTree expressionTree = uniqueAssignedValue.get();
            return CheckUtils.isTrueValue(expressionTree);
        }
        return false;
    }

    @Override
    public void setBundle(CheckBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public CheckBundle getBundle() {
        return this.bundle;
    }
}

