/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php;

import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.DurationStatistics;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.php.compat.PhpFileImpl;
import org.sonar.php.filters.SuppressWarningFilter;
import org.sonar.php.metrics.CommentLineVisitor;
import org.sonar.php.metrics.FileMeasures;
import org.sonar.php.metrics.MetricsVisitor;
import org.sonar.php.parser.PHPParserBuilder;
import org.sonar.php.symbols.ProjectSymbolData;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.php.tree.visitors.PHPCheckContext;
import org.sonar.plugins.php.api.cache.CacheContext;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PhpFile;
import org.sonar.plugins.php.api.visitors.PhpInputFileContext;
import org.sonar.plugins.php.api.visitors.PhpIssue;

public class PHPAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(PHPAnalyzer.class);
    private final ActionParser<Tree> parser = PHPParserBuilder.createParser();
    private final List<PHPCheck> checks;
    private final List<PHPCheck> testFileChecks;
    @Nullable
    private final File workingDir;
    private final ProjectSymbolData projectSymbolData;
    private final DurationStatistics statistics;
    private final CacheContext cacheContext;
    private final SuppressWarningFilter suppressWarningFilter;
    private final boolean frameworkDetectionEnabled;
    private PhpInputFileContext currentFileContext;
    private CompilationUnitTree currentFileTree;
    private PhpFile currentFile;
    private SymbolTable currentFileSymbolTable;

    public PHPAnalyzer(List<PHPCheck> checks, List<PHPCheck> testFileChecks, @Nullable File workingDir, ProjectSymbolData projectSymbolData, DurationStatistics statistics, @Nullable CacheContext cacheContext, SuppressWarningFilter suppressWarningFilter, boolean frameworkDetectionEnabled) {
        this.checks = checks;
        this.testFileChecks = testFileChecks;
        this.workingDir = workingDir;
        this.projectSymbolData = projectSymbolData;
        this.statistics = statistics;
        this.cacheContext = cacheContext;
        this.suppressWarningFilter = suppressWarningFilter;
        this.frameworkDetectionEnabled = frameworkDetectionEnabled;
        for (PHPCheck check : checks) {
            check.init();
        }
    }

    public void nextFile(InputFile inputFile) throws RecognitionException {
        this.currentFile = PhpFileImpl.create(inputFile);
        this.currentFileContext = new PhpInputFileContext(this.currentFile, this.workingDir, this.cacheContext);
        this.currentFileTree = (CompilationUnitTree)this.statistics.time("CheckParsing", () -> this.parser.parse(this.currentFile.contents()));
        this.currentFileSymbolTable = this.statistics.time("CheckSymbolTable", () -> SymbolTableImpl.create(this.currentFileTree, this.projectSymbolData, PhpFileImpl.create(inputFile), this.frameworkDetectionEnabled));
    }

    public List<PhpIssue> analyze() {
        ArrayList<PhpIssue> allIssues = new ArrayList<PhpIssue>();
        for (PHPCheck check : this.checks) {
            PHPCheckContext context = new PHPCheckContext(this.currentFileContext, this.currentFileTree, this.currentFileSymbolTable);
            List issues = this.statistics.time(check.getClass().getSimpleName(), () -> {
                try {
                    return check.analyze(context);
                }
                catch (StackOverflowError e) {
                    LOG.warn("Stack overflow of {} in file {}", (Object)check.getClass().getName(), (Object)this.currentFile.uri());
                    throw e;
                }
            });
            allIssues.addAll(issues);
        }
        PHPCheckContext context = new PHPCheckContext(this.currentFileContext, this.currentFileTree, this.currentFileSymbolTable);
        this.suppressWarningFilter.analyze(context);
        return allIssues;
    }

    public List<PhpIssue> analyzeTest() {
        PHPCheckContext context = new PHPCheckContext(this.currentFileContext, this.currentFileTree, this.currentFileSymbolTable);
        this.suppressWarningFilter.analyze(context);
        return this.testFileChecks.stream().map(check -> check.analyze(new PHPCheckContext(this.currentFileContext, this.currentFileTree, this.currentFileSymbolTable))).flatMap(Collection::stream).toList();
    }

    public void terminate() {
        for (PHPCheck check : this.checks) {
            try {
                check.terminate();
            }
            catch (Exception e) {
                LOG.warn("An error occurred while trying to terminate checks:", (Throwable)e);
            }
        }
    }

    public FileMeasures computeMeasures(FileLinesContext fileLinesContext) {
        return new MetricsVisitor().getFileMeasures(this.currentFile, this.currentFileTree, this.currentFileSymbolTable, fileLinesContext);
    }

    public Set<Integer> computeNoSonarLines() {
        return new CommentLineVisitor(this.currentFileTree).noSonarLines();
    }

    public CompilationUnitTree currentFileTree() {
        return this.currentFileTree;
    }

    public SymbolTable currentFileSymbolTable() {
        return this.currentFileSymbolTable;
    }
}

