/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.List;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.runtime.AbstractStringScriptFieldQuery;

public abstract class AbstractStringScriptFieldAutomatonQuery
extends AbstractStringScriptFieldQuery {
    private final ByteRunAutomaton automaton;

    public AbstractStringScriptFieldAutomatonQuery(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, ByteRunAutomaton automaton) {
        super(script, leafFactory, fieldName);
        this.automaton = automaton;
    }

    @Override
    protected TwoPhaseIterator createTwoPhaseIterator(final StringFieldScript scriptContext, DocIdSetIterator approximation) {
        final BytesRefBuilder scratch = new BytesRefBuilder();
        return new TwoPhaseIterator(approximation){

            public boolean matches() {
                scriptContext.runForDoc(this.approximation.docID());
                return AbstractStringScriptFieldAutomatonQuery.this.matches(scriptContext.getValues(), scratch);
            }

            public float matchCost() {
                return 9000.0f;
            }
        };
    }

    protected final boolean matches(List<String> values, BytesRefBuilder scratch) {
        for (String value : values) {
            scratch.copyChars((CharSequence)value);
            if (!this.automaton.run(scratch.bytes(), 0, scratch.length())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final boolean matches(List<String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName())) {
            visitor.consumeTermsMatching((Query)this, this.fieldName(), () -> this.automaton);
        }
    }
}

