/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.AggregatorsReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.search.sort.SortValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class InternalAggregations
implements Iterable<InternalAggregation>,
ToXContentFragment,
Writeable {
    public static final String AGGREGATIONS_FIELD = "aggregations";
    public static final InternalAggregations EMPTY = new InternalAggregations(List.of());
    private final List<InternalAggregation> aggregations;
    private Map<String, InternalAggregation> aggregationsAsMap;

    private InternalAggregations(List<InternalAggregation> aggregations) {
        this.aggregations = aggregations;
        if (aggregations.isEmpty()) {
            this.aggregationsAsMap = Map.of();
        }
    }

    @Override
    public Iterator<InternalAggregation> iterator() {
        return this.aggregations.iterator();
    }

    public List<InternalAggregation> asList() {
        return this.aggregations;
    }

    private Map<String, InternalAggregation> asMap() {
        Map<String, InternalAggregation> res = this.aggregationsAsMap;
        if (res == null) {
            Map<String, InternalAggregation> newAggregationsAsMap = Maps.newMapWithExpectedSize(this.aggregations.size());
            for (InternalAggregation aggregation : this.aggregations) {
                newAggregationsAsMap.put(aggregation.getName(), aggregation);
            }
            res = this.aggregationsAsMap = Collections.unmodifiableMap(newAggregationsAsMap);
        }
        return res;
    }

    public <A extends InternalAggregation> A get(String name) {
        return (A)this.asMap().get(name);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.aggregations.equals(((InternalAggregations)obj).aggregations);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.aggregations);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.aggregations.isEmpty()) {
            return builder;
        }
        builder.startObject(AGGREGATIONS_FIELD);
        this.toXContentInternal(builder, params);
        return builder.endObject();
    }

    public XContentBuilder toXContentInternal(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (InternalAggregation aggregation : this.aggregations) {
            aggregation.toXContent(builder, params);
        }
        return builder;
    }

    public static InternalAggregations fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.START_OBJECT) continue;
            SetOnce typedAgg = new SetOnce();
            String currentField = parser.currentName();
            XContentParserUtils.parseTypedKeysObject(parser, "#", InternalAggregation.class, arg_0 -> ((SetOnce)typedAgg).set(arg_0));
            if (typedAgg.get() != null) {
                aggregations.add((InternalAggregation)typedAgg.get());
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Could not parse aggregation keyed as [%s]", currentField), new Object[0]);
        }
        return new InternalAggregations(aggregations);
    }

    public static InternalAggregations from(InternalAggregation aggregation) {
        return new InternalAggregations(List.of(aggregation));
    }

    public static InternalAggregations from(List<InternalAggregation> aggregations) {
        if (aggregations.isEmpty()) {
            return EMPTY;
        }
        if (aggregations.size() == 1) {
            return InternalAggregations.from(aggregations.get(0));
        }
        return new InternalAggregations(aggregations);
    }

    public static InternalAggregations append(InternalAggregations aggs, InternalAggregation toAppend) {
        if (aggs.aggregations.isEmpty()) {
            return InternalAggregations.from(toAppend);
        }
        return new InternalAggregations(CollectionUtils.appendToCopyNoNullElements(aggs.aggregations, toAppend));
    }

    public static InternalAggregations readFrom(StreamInput in) throws IOException {
        return InternalAggregations.from(in.readNamedWriteableCollectionAsList(InternalAggregation.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableCollection(this.getInternalAggregations());
    }

    public List<InternalAggregation> copyResults() {
        return new ArrayList<InternalAggregation>(this.getInternalAggregations());
    }

    private List<InternalAggregation> getInternalAggregations() {
        return this.aggregations;
    }

    public SortValue sortValue(AggregationPath.PathElement head, Iterator<AggregationPath.PathElement> tail) {
        Object aggregation = this.get(head.name());
        if (aggregation == null) {
            throw new IllegalArgumentException("Cannot find aggregation named [" + head.name() + "]");
        }
        if (tail.hasNext()) {
            return ((InternalAggregation)aggregation).sortValue(tail.next(), tail);
        }
        return ((InternalAggregation)aggregation).sortValue(Optional.ofNullable(head.key()).orElse(head.metric()));
    }

    public static InternalAggregations topLevelReduce(Iterator<InternalAggregations> aggs, int count, AggregationReduceContext context) {
        if (count == 0) {
            return null;
        }
        return InternalAggregations.maybeExecuteFinalReduce(context, count == 1 ? InternalAggregations.reduce(aggs.next(), context) : InternalAggregations.reduce(aggs, count, context));
    }

    private static InternalAggregations maybeExecuteFinalReduce(AggregationReduceContext context, InternalAggregations reduced) {
        if (reduced == null) {
            return null;
        }
        if (context.isFinalReduce()) {
            List reducedInternalAggs = reduced.getInternalAggregations().stream().map(agg -> agg.reducePipelines((InternalAggregation)agg, context, context.pipelineTreeRoot().subTree(agg.getName()))).collect(Collectors.toCollection(ArrayList::new));
            for (PipelineAggregator pipelineAggregator : context.pipelineTreeRoot().aggregators()) {
                SiblingPipelineAggregator sib = (SiblingPipelineAggregator)pipelineAggregator;
                InternalAggregation newAgg = sib.doReduce(InternalAggregations.from(reducedInternalAggs), context);
                reducedInternalAggs.add(newAgg);
            }
            return InternalAggregations.from(reducedInternalAggs);
        }
        return reduced;
    }

    public static InternalAggregations topLevelReduce(List<InternalAggregations> aggregationsList, AggregationReduceContext context) {
        return InternalAggregations.maybeExecuteFinalReduce(context, InternalAggregations.reduce(aggregationsList, context));
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, AggregationReduceContext context) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        if (aggregationsList.size() == 1) {
            return InternalAggregations.reduce(aggregationsList.get(0), context);
        }
        try (AggregatorsReducer reducer = new AggregatorsReducer(aggregationsList.get(0), context, aggregationsList.size());){
            for (InternalAggregations aggregations : aggregationsList) {
                reducer.accept(aggregations);
            }
            InternalAggregations internalAggregations = reducer.get();
            return internalAggregations;
        }
    }

    private static InternalAggregations reduce(Iterator<InternalAggregations> aggsIterator, int count, AggregationReduceContext context) {
        InternalAggregations first = aggsIterator.next();
        try (AggregatorsReducer reducer = new AggregatorsReducer(first, context, count);){
            reducer.accept(first);
            aggsIterator.forEachRemaining(reducer::accept);
            InternalAggregations internalAggregations = reducer.get();
            return internalAggregations;
        }
    }

    public static InternalAggregations reduce(InternalAggregations aggregations, AggregationReduceContext context) {
        List<InternalAggregation> internalAggregations = aggregations.asList();
        int size = internalAggregations.size();
        if (size == 0) {
            return EMPTY;
        }
        boolean noneReduced = true;
        ArrayList<InternalAggregation> reduced = new ArrayList<InternalAggregation>(size);
        for (int i = 0; i < size; ++i) {
            InternalAggregation aggregation = internalAggregations.get(i);
            if (aggregation.mustReduceOnSingleInternalAgg()) {
                noneReduced = false;
                try (AggregatorReducer aggregatorReducer = aggregation.getReducer(context.forAgg(aggregation.getName()), 1);){
                    aggregatorReducer.accept(aggregation);
                    reduced.add(aggregatorReducer.get());
                    continue;
                }
            }
            reduced.add(aggregation);
        }
        return noneReduced ? aggregations : InternalAggregations.from(reduced);
    }

    public static InternalAggregations finalizeSampling(InternalAggregations internalAggregations, SamplingContext samplingContext) {
        return InternalAggregations.from(internalAggregations.aggregations.stream().map(agg -> agg.finalizeSampling(samplingContext)).collect(Collectors.toList()));
    }
}

