/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.Optional;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class AggregationErrors {
    private AggregationErrors() {
    }

    public static IllegalArgumentException invalidPathElement(String element, String path) {
        return new IllegalArgumentException("Invalid path element [" + element + "] in path [" + path + "]");
    }

    public static IllegalArgumentException unsupportedValuesSourceType(ValuesSource valuesSource, String name) {
        return new IllegalArgumentException("ValuesSource type [" + valuesSource.toString() + "] is not supported for aggregation [" + name + "]");
    }

    public static RuntimeException rateWithoutDateHistogram(String name) {
        return new IllegalArgumentException("aggregation [" + name + "] does not have exactly one date_histogram value source; exactly one is required when using with rate aggregation");
    }

    public static RuntimeException reduceTypeMismatch(String aggregationName, Optional<Integer> position) {
        Object fieldString = position.isPresent() ? "the field in position" + position.get().toString() : "the field you gave";
        return new IllegalArgumentException("Merging/Reducing the aggregations failed when computing the aggregation [" + aggregationName + "] because " + (String)fieldString + " in the aggregation query existed as two different types in two different indices");
    }

    public static RuntimeException valuesSourceDoesNotSupportScritps(String typeName) {
        return new IllegalArgumentException("value source of type [" + typeName + "] is not supported by scripts");
    }

    public static RuntimeException unsupportedScriptValue(String actual) {
        return new IllegalArgumentException("Unsupported script value [" + actual + "], expected a number, date, or boolean");
    }

    public static RuntimeException unsupportedMultivalue() {
        return new IllegalArgumentException("Encountered more than one value for a single document. Use a script to combine multiple values per doc into a single value.");
    }

    public static RuntimeException unsupportedMultivalueValuesSource(String source) {
        throw new IllegalArgumentException("ValuesSource type " + source + "is not supported for multi-valued aggregation");
    }

    public static RuntimeException unsupportedRounding(String typeName) {
        return new IllegalArgumentException("can't round a [" + typeName + "]");
    }

    public static RuntimeException incompatibleAggregationType(String aggPath, String expected, String got, String currentAgg) {
        return new AggregationExecutionException.InvalidPath(aggPath + " must reference a " + expected + " aggregation, got: [" + (got == null ? "null" : got) + "] at aggregation [" + currentAgg + "]");
    }

    public static RuntimeException iterationOrderChangedWithoutMutating(String bucketOrds, long got, long expected) {
        return new AggregationExecutionException("Iteration order of [" + bucketOrds + "] changed without mutating. [" + got + "] should have been [" + expected + "]");
    }
}

