/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.xcontent.FilterXContentParser;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentString;
import org.elasticsearch.xcontent.XContentSubParser;

class DotExpandingXContentParser
extends FilterXContentParserWrapper {
    private final ContentPath contentPath;
    private String[] subPaths;
    private XContentLocation currentLocation;
    private int expandedTokens = 0;
    private int innerLevel = -1;
    private State state = State.EXPANDING_START_OBJECT;

    static boolean isInstance(XContentParser parser) {
        return parser instanceof WrappingParser;
    }

    static XContentParser expandDots(XContentParser in, ContentPath contentPath) throws IOException {
        return new WrappingParser(in, contentPath);
    }

    private DotExpandingXContentParser(XContentParser subparser, String[] subPaths, XContentLocation startLocation, ContentPath contentPath) {
        super(subparser);
        this.subPaths = subPaths;
        this.currentLocation = startLocation;
        this.contentPath = contentPath;
    }

    public XContentParser.Token nextToken() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            ++this.expandedTokens;
            assert (this.expandedTokens < this.subPaths.length * 2);
            if (this.expandedTokens == this.subPaths.length * 2 - 1) {
                this.state = State.PARSING_ORIGINAL_CONTENT;
                XContentParser.Token token = this.delegate().currentToken();
                if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                    ++this.innerLevel;
                }
                return token;
            }
            if (this.expandedTokens % 2 == 0) {
                int currentIndex = this.expandedTokens / 2;
                if (currentIndex < this.subPaths.length - 1 && this.contentPath.isWithinLeafObject()) {
                    String[] newSubPaths = new String[currentIndex + 1];
                    StringBuilder collapsedPath = new StringBuilder();
                    for (int i = 0; i < this.subPaths.length; ++i) {
                        if (i < currentIndex) {
                            newSubPaths[i] = this.subPaths[i];
                            continue;
                        }
                        collapsedPath.append(this.subPaths[i]);
                        if (i >= this.subPaths.length - 1) continue;
                        collapsedPath.append(".");
                    }
                    newSubPaths[currentIndex] = collapsedPath.toString();
                    this.subPaths = newSubPaths;
                }
                return XContentParser.Token.FIELD_NAME;
            }
            return XContentParser.Token.START_OBJECT;
        }
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            XContentParser.Token token = this.delegate().nextToken();
            if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                ++this.innerLevel;
            }
            if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                --this.innerLevel;
            }
            if (token != null) {
                return token;
            }
            this.currentLocation = this.getTokenLocation();
            this.state = State.ENDING_EXPANDED_OBJECT;
        }
        assert (this.expandedTokens % 2 == 1);
        this.expandedTokens -= 2;
        return this.expandedTokens < 0 ? null : XContentParser.Token.END_OBJECT;
    }

    public XContentLocation getTokenLocation() {
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            return super.getTokenLocation();
        }
        return this.currentLocation;
    }

    public XContentParser.Token currentToken() {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.EXPANDING_START_OBJECT -> {
                if (this.expandedTokens % 2 == 1) {
                    yield XContentParser.Token.START_OBJECT;
                }
                yield XContentParser.Token.FIELD_NAME;
            }
            case State.ENDING_EXPANDED_OBJECT -> XContentParser.Token.END_OBJECT;
            case State.PARSING_ORIGINAL_CONTENT -> this.delegate().currentToken();
        };
    }

    public String currentName() throws IOException {
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            assert (this.expandedTokens == this.subPaths.length * 2 - 1);
            if (this.innerLevel > 0) {
                return this.delegate().currentName();
            }
            XContentParser.Token token = this.currentToken();
            if (this.innerLevel == 0 && token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
                return this.delegate().currentName();
            }
        }
        return this.subPaths[this.expandedTokens / 2];
    }

    public void skipChildren() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            this.delegate().skipChildren();
            this.state = State.ENDING_EXPANDED_OBJECT;
        }
        if (this.state == State.PARSING_ORIGINAL_CONTENT) {
            this.delegate().skipChildren();
        }
    }

    public XContentString optimizedTextOrNull() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get text on a " + String.valueOf(this.currentToken()) + " at " + String.valueOf(this.getTokenLocation()));
        }
        return super.optimizedTextOrNull();
    }

    public String textOrNull() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get text on a " + String.valueOf(this.currentToken()) + " at " + String.valueOf(this.getTokenLocation()));
        }
        return super.textOrNull();
    }

    public Number numberValue() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get numeric value on a " + String.valueOf(this.currentToken()) + " at " + String.valueOf(this.getTokenLocation()));
        }
        return super.numberValue();
    }

    public boolean booleanValue() throws IOException {
        if (this.state == State.EXPANDING_START_OBJECT) {
            throw new IllegalStateException("Can't get boolean value on a " + String.valueOf(this.currentToken()) + " at " + String.valueOf(this.getTokenLocation()));
        }
        return super.booleanValue();
    }

    private static final class WrappingParser
    extends FilterXContentParser {
        private final ContentPath contentPath;
        final Deque<XContentParser> parsers = new ArrayDeque<XContentParser>();

        WrappingParser(XContentParser in, ContentPath contentPath) throws IOException {
            this.contentPath = contentPath;
            this.parsers.push(in);
            if (in.currentToken() == XContentParser.Token.FIELD_NAME) {
                this.expandDots(in);
            }
        }

        public XContentParser.Token nextToken() throws IOException {
            XContentParser delegate;
            XContentParser.Token token;
            Deque<XContentParser> parsers = this.parsers;
            while ((token = (delegate = parsers.peek()).nextToken()) == null) {
                parsers.pop();
                if (!parsers.isEmpty()) continue;
                return null;
            }
            if (token != XContentParser.Token.FIELD_NAME) {
                return token;
            }
            this.expandDots(delegate);
            return XContentParser.Token.FIELD_NAME;
        }

        private void expandDots(XContentParser delegate) throws IOException {
            if (this.contentPath.isWithinLeafObject()) {
                return;
            }
            String field = delegate.currentName();
            int length = field.length();
            if (length == 0) {
                throw new IllegalArgumentException("field name cannot be an empty string");
            }
            int dotCount = FieldTypeLookup.dotCount(field);
            if (dotCount == 0) {
                return;
            }
            this.doExpandDots(delegate, field, dotCount);
        }

        private void doExpandDots(XContentParser delegate, String field, int dotCount) throws IOException {
            String[] subpaths;
            int resultSize;
            int offset = 0;
            String[] list = new String[dotCount + 1];
            int listIndex = 0;
            for (int i = 0; i < dotCount; ++i) {
                int next = field.indexOf(46, offset);
                list[listIndex++] = field.substring(offset, next);
                offset = next + 1;
            }
            list[listIndex] = field.substring(offset);
            for (resultSize = list.length; resultSize > 0 && list[resultSize - 1].isEmpty(); --resultSize) {
            }
            if (resultSize == 0) {
                throw new IllegalArgumentException("field name cannot contain only dots");
            }
            if (resultSize == list.length) {
                for (String part : list) {
                    if (!part.isBlank()) continue;
                    WrappingParser.throwOnBlankOrEmptyPart(field, part);
                }
                subpaths = list;
            } else {
                if (resultSize == 1 && !field.endsWith(".")) {
                    return;
                }
                subpaths = WrappingParser.extractAndValidateResults(field, list, resultSize);
            }
            this.pushSubParser(delegate, subpaths);
        }

        private void pushSubParser(XContentParser delegate, String[] subpaths) throws IOException {
            Object subParser;
            XContentLocation location = delegate.getTokenLocation();
            XContentParser.Token token = delegate.nextToken();
            if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                subParser = new XContentSubParser(delegate);
            } else {
                if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                    WrappingParser.throwExpectedOpen(token);
                }
                subParser = new SingletonValueXContentParser(delegate);
            }
            this.parsers.push((XContentParser)new DotExpandingXContentParser((XContentParser)subParser, subpaths, location, this.contentPath));
        }

        private static void throwExpectedOpen(XContentParser.Token token) {
            throw new IllegalStateException("Expecting START_OBJECT or START_ARRAY or VALUE but got [" + String.valueOf(token) + "]");
        }

        private static String[] extractAndValidateResults(String field, String[] list, int resultSize) {
            String[] subpaths = new String[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                String part = list[i];
                if (part.isBlank()) {
                    WrappingParser.throwOnBlankOrEmptyPart(field, part);
                }
                subpaths[i] = part;
            }
            return subpaths;
        }

        private static void throwOnBlankOrEmptyPart(String field, String part) {
            if (part.isEmpty()) {
                throw new IllegalArgumentException("field name cannot contain only whitespace: ['" + field + "']");
            }
            throw new IllegalArgumentException("field name starting or ending with a [.] makes object resolution ambiguous: [" + field + "]");
        }

        protected XContentParser delegate() {
            return this.parsers.peek();
        }

        public Map<String, Object> map() throws IOException {
            if (this.contentPath.isWithinLeafObject()) {
                return super.map();
            }
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> mapOrdered() throws IOException {
            if (this.contentPath.isWithinLeafObject()) {
                return super.mapOrdered();
            }
            throw new UnsupportedOperationException();
        }

        public Map<String, String> mapStrings() throws IOException {
            if (this.contentPath.isWithinLeafObject()) {
                return super.mapStrings();
            }
            throw new UnsupportedOperationException();
        }

        public <T> Map<String, T> map(Supplier<Map<String, T>> mapFactory, CheckedFunction<XContentParser, T, IOException> mapValueParser) throws IOException {
            if (this.contentPath.isWithinLeafObject()) {
                return super.map(mapFactory, mapValueParser);
            }
            throw new UnsupportedOperationException();
        }

        public List<Object> list() throws IOException {
            if (this.contentPath.isWithinLeafObject()) {
                return super.list();
            }
            throw new UnsupportedOperationException();
        }

        public List<Object> listOrderedMap() throws IOException {
            if (this.contentPath.isWithinLeafObject()) {
                return super.listOrderedMap();
            }
            throw new UnsupportedOperationException();
        }
    }

    private static enum State {
        EXPANDING_START_OBJECT,
        PARSING_ORIGINAL_CONTENT,
        ENDING_EXPANDED_OBJECT;

    }

    private static class SingletonValueXContentParser
    extends FilterXContentParserWrapper {
        protected SingletonValueXContentParser(XContentParser in) {
            super(in);
        }

        public XContentParser.Token nextToken() throws IOException {
            return null;
        }
    }
}

