/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.internal;

import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.TransportIndicesAliasesAction;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesAction;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequestBuilder;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequestBuilder;
import org.elasticsearch.action.admin.indices.cache.clear.TransportClearIndicesCacheAction;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.close.TransportCloseIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.admin.indices.flush.FlushAction;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeAction;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.TransportPutMappingAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockRequest;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockRequestBuilder;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockResponse;
import org.elasticsearch.action.admin.indices.readonly.TransportAddIndexBlockAction;
import org.elasticsearch.action.admin.indices.recovery.RecoveryAction;
import org.elasticsearch.action.admin.indices.recovery.RecoveryRequest;
import org.elasticsearch.action.admin.indices.recovery.RecoveryRequestBuilder;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.resolve.ResolveIndexAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequestBuilder;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsAction;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.shrink.ResizeAction;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequestBuilder;
import org.elasticsearch.action.admin.indices.template.delete.TransportDeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequestBuilder;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.elasticsearch.action.admin.indices.template.put.TransportPutIndexTemplateAction;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryAction;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequestBuilder;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesAdminClient
implements ElasticsearchClient {
    protected final ElasticsearchClient client;

    public IndicesAdminClient(ElasticsearchClient client) {
        this.client = client;
    }

    public ActionFuture<IndicesStatsResponse> stats(IndicesStatsRequest request) {
        return this.execute(IndicesStatsAction.INSTANCE, request);
    }

    public void stats(IndicesStatsRequest request, ActionListener<IndicesStatsResponse> listener) {
        this.execute(IndicesStatsAction.INSTANCE, request, listener);
    }

    public IndicesStatsRequestBuilder prepareStats(String ... indices) {
        return (IndicesStatsRequestBuilder)new IndicesStatsRequestBuilder(this).setIndices(indices);
    }

    public ActionFuture<RecoveryResponse> recoveries(RecoveryRequest request) {
        return this.execute(RecoveryAction.INSTANCE, request);
    }

    public void recoveries(RecoveryRequest request, ActionListener<RecoveryResponse> listener) {
        this.execute(RecoveryAction.INSTANCE, request, listener);
    }

    public RecoveryRequestBuilder prepareRecoveries(String ... indices) {
        return (RecoveryRequestBuilder)new RecoveryRequestBuilder(this).setIndices(indices);
    }

    public ActionFuture<IndicesSegmentResponse> segments(IndicesSegmentsRequest request) {
        return this.execute(IndicesSegmentsAction.INSTANCE, request);
    }

    public void segments(IndicesSegmentsRequest request, ActionListener<IndicesSegmentResponse> listener) {
        this.execute(IndicesSegmentsAction.INSTANCE, request, listener);
    }

    public IndicesSegmentsRequestBuilder prepareSegments(String ... indices) {
        return (IndicesSegmentsRequestBuilder)new IndicesSegmentsRequestBuilder(this).setIndices(indices);
    }

    public ActionFuture<CreateIndexResponse> create(CreateIndexRequest request) {
        return this.execute(TransportCreateIndexAction.TYPE, request);
    }

    public void create(CreateIndexRequest request, ActionListener<CreateIndexResponse> listener) {
        this.execute(TransportCreateIndexAction.TYPE, request, listener);
    }

    public CreateIndexRequestBuilder prepareCreate(String index) {
        return new CreateIndexRequestBuilder(this, index);
    }

    public ActionFuture<AcknowledgedResponse> delete(DeleteIndexRequest request) {
        return this.execute(TransportDeleteIndexAction.TYPE, request);
    }

    public void delete(DeleteIndexRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.execute(TransportDeleteIndexAction.TYPE, request, listener);
    }

    public DeleteIndexRequestBuilder prepareDelete(String ... indices) {
        return new DeleteIndexRequestBuilder((ElasticsearchClient)this, indices);
    }

    public ActionFuture<CloseIndexResponse> close(CloseIndexRequest request) {
        return this.execute(TransportCloseIndexAction.TYPE, request);
    }

    public void close(CloseIndexRequest request, ActionListener<CloseIndexResponse> listener) {
        this.execute(TransportCloseIndexAction.TYPE, request, listener);
    }

    public CloseIndexRequestBuilder prepareClose(String ... indices) {
        return new CloseIndexRequestBuilder((ElasticsearchClient)this, indices);
    }

    public ActionFuture<OpenIndexResponse> open(OpenIndexRequest request) {
        return this.execute(OpenIndexAction.INSTANCE, request);
    }

    public void open(OpenIndexRequest request, ActionListener<OpenIndexResponse> listener) {
        this.execute(OpenIndexAction.INSTANCE, request, listener);
    }

    public AddIndexBlockRequestBuilder prepareAddBlock(IndexMetadata.APIBlock block, String ... indices) {
        return new AddIndexBlockRequestBuilder((ElasticsearchClient)this, block, indices);
    }

    public void addBlock(AddIndexBlockRequest request, ActionListener<AddIndexBlockResponse> listener) {
        this.execute(TransportAddIndexBlockAction.TYPE, request, listener);
    }

    public OpenIndexRequestBuilder prepareOpen(String ... indices) {
        return new OpenIndexRequestBuilder((ElasticsearchClient)this, indices);
    }

    public ActionFuture<BroadcastResponse> refresh(RefreshRequest request) {
        return this.execute(RefreshAction.INSTANCE, request);
    }

    public void refresh(RefreshRequest request, ActionListener<BroadcastResponse> listener) {
        this.execute(RefreshAction.INSTANCE, request, listener);
    }

    public RefreshRequestBuilder prepareRefresh(String ... indices) {
        return (RefreshRequestBuilder)new RefreshRequestBuilder(this).setIndices(indices);
    }

    public ActionFuture<BroadcastResponse> flush(FlushRequest request) {
        return this.execute(FlushAction.INSTANCE, request);
    }

    public void flush(FlushRequest request, ActionListener<BroadcastResponse> listener) {
        this.execute(FlushAction.INSTANCE, request, listener);
    }

    public FlushRequestBuilder prepareFlush(String ... indices) {
        return (FlushRequestBuilder)new FlushRequestBuilder(this).setIndices(indices);
    }

    public ActionFuture<BroadcastResponse> forceMerge(ForceMergeRequest request) {
        return this.execute(ForceMergeAction.INSTANCE, request);
    }

    public void forceMerge(ForceMergeRequest request, ActionListener<BroadcastResponse> listener) {
        this.execute(ForceMergeAction.INSTANCE, request, listener);
    }

    public ForceMergeRequestBuilder prepareForceMerge(String ... indices) {
        return (ForceMergeRequestBuilder)new ForceMergeRequestBuilder(this).setIndices(indices);
    }

    public void getMappings(GetMappingsRequest request, ActionListener<GetMappingsResponse> listener) {
        this.execute(GetMappingsAction.INSTANCE, request, listener);
    }

    public ActionFuture<GetMappingsResponse> getMappings(GetMappingsRequest request) {
        return this.execute(GetMappingsAction.INSTANCE, request);
    }

    public GetMappingsRequestBuilder prepareGetMappings(String ... indices) {
        return new GetMappingsRequestBuilder((ElasticsearchClient)this, indices);
    }

    public void getFieldMappings(GetFieldMappingsRequest request, ActionListener<GetFieldMappingsResponse> listener) {
        this.execute(GetFieldMappingsAction.INSTANCE, request, listener);
    }

    public GetFieldMappingsRequestBuilder prepareGetFieldMappings(String ... indices) {
        return new GetFieldMappingsRequestBuilder((ElasticsearchClient)this, indices);
    }

    public ActionFuture<GetFieldMappingsResponse> getFieldMappings(GetFieldMappingsRequest request) {
        return this.execute(GetFieldMappingsAction.INSTANCE, request);
    }

    public ActionFuture<AcknowledgedResponse> putMapping(PutMappingRequest request) {
        return this.execute(TransportPutMappingAction.TYPE, request);
    }

    public void putMapping(PutMappingRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.execute(TransportPutMappingAction.TYPE, request, listener);
    }

    public PutMappingRequestBuilder preparePutMapping(String ... indices) {
        return new PutMappingRequestBuilder(this).setIndices(indices);
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> ActionFuture<Response> execute(ActionType<Response> action, Request request) {
        return this.client.execute(action, request);
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.client.execute(action, request, listener);
    }

    @Override
    public ThreadPool threadPool() {
        return this.client.threadPool();
    }

    public ActionFuture<IndicesAliasesResponse> aliases(IndicesAliasesRequest request) {
        return this.execute(TransportIndicesAliasesAction.TYPE, request);
    }

    public void aliases(IndicesAliasesRequest request, ActionListener<IndicesAliasesResponse> listener) {
        this.execute(TransportIndicesAliasesAction.TYPE, request, listener);
    }

    public IndicesAliasesRequestBuilder prepareAliases() {
        return new IndicesAliasesRequestBuilder(this);
    }

    public ActionFuture<GetAliasesResponse> getAliases(GetAliasesRequest request) {
        return this.execute(GetAliasesAction.INSTANCE, request);
    }

    public void getAliases(GetAliasesRequest request, ActionListener<GetAliasesResponse> listener) {
        this.execute(GetAliasesAction.INSTANCE, request, listener);
    }

    public GetAliasesRequestBuilder prepareGetAliases(String ... aliases) {
        return new GetAliasesRequestBuilder((ElasticsearchClient)this, aliases);
    }

    public ActionFuture<GetIndexResponse> getIndex(GetIndexRequest request) {
        return this.execute(GetIndexAction.INSTANCE, request);
    }

    public void getIndex(GetIndexRequest request, ActionListener<GetIndexResponse> listener) {
        this.execute(GetIndexAction.INSTANCE, request, listener);
    }

    public GetIndexRequestBuilder prepareGetIndex() {
        return new GetIndexRequestBuilder((ElasticsearchClient)this, new String[0]);
    }

    public ActionFuture<BroadcastResponse> clearCache(ClearIndicesCacheRequest request) {
        return this.execute(TransportClearIndicesCacheAction.TYPE, request);
    }

    public void clearCache(ClearIndicesCacheRequest request, ActionListener<BroadcastResponse> listener) {
        this.execute(TransportClearIndicesCacheAction.TYPE, request, listener);
    }

    public ClearIndicesCacheRequestBuilder prepareClearCache(String ... indices) {
        return (ClearIndicesCacheRequestBuilder)new ClearIndicesCacheRequestBuilder(this).setIndices(indices);
    }

    public ActionFuture<AcknowledgedResponse> updateSettings(UpdateSettingsRequest request) {
        return this.execute(TransportUpdateSettingsAction.TYPE, request);
    }

    public void updateSettings(UpdateSettingsRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.execute(TransportUpdateSettingsAction.TYPE, request, listener);
    }

    public UpdateSettingsRequestBuilder prepareUpdateSettings(String ... indices) {
        return new UpdateSettingsRequestBuilder((ElasticsearchClient)this, new String[0]).setIndices(indices);
    }

    public ActionFuture<AnalyzeAction.Response> analyze(AnalyzeAction.Request request) {
        return this.execute(AnalyzeAction.INSTANCE, request);
    }

    public void analyze(AnalyzeAction.Request request, ActionListener<AnalyzeAction.Response> listener) {
        this.execute(AnalyzeAction.INSTANCE, request, listener);
    }

    public AnalyzeRequestBuilder prepareAnalyze(@Nullable String index, String text) {
        return new AnalyzeRequestBuilder((ElasticsearchClient)this, index, text);
    }

    public AnalyzeRequestBuilder prepareAnalyze(String text) {
        return new AnalyzeRequestBuilder((ElasticsearchClient)this, null, new String[]{text});
    }

    public AnalyzeRequestBuilder prepareAnalyze() {
        return new AnalyzeRequestBuilder(this);
    }

    public ActionFuture<AcknowledgedResponse> putTemplate(PutIndexTemplateRequest request) {
        return this.execute(TransportPutIndexTemplateAction.TYPE, request);
    }

    public void putTemplate(PutIndexTemplateRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.execute(TransportPutIndexTemplateAction.TYPE, request, listener);
    }

    public PutIndexTemplateRequestBuilder preparePutTemplate(String name) {
        return new PutIndexTemplateRequestBuilder(this, name);
    }

    public void deleteTemplate(DeleteIndexTemplateRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.execute(TransportDeleteIndexTemplateAction.TYPE, request, listener);
    }

    public DeleteIndexTemplateRequestBuilder prepareDeleteTemplate(String name) {
        return new DeleteIndexTemplateRequestBuilder(this, name);
    }

    public void getTemplates(GetIndexTemplatesRequest request, ActionListener<GetIndexTemplatesResponse> listener) {
        this.execute(GetIndexTemplatesAction.INSTANCE, request, listener);
    }

    public GetIndexTemplatesRequestBuilder prepareGetTemplates(String ... names) {
        return new GetIndexTemplatesRequestBuilder((ElasticsearchClient)this, names);
    }

    public ActionFuture<ValidateQueryResponse> validateQuery(ValidateQueryRequest request) {
        return this.execute(ValidateQueryAction.INSTANCE, request);
    }

    public void validateQuery(ValidateQueryRequest request, ActionListener<ValidateQueryResponse> listener) {
        this.execute(ValidateQueryAction.INSTANCE, request, listener);
    }

    public ValidateQueryRequestBuilder prepareValidateQuery(String ... indices) {
        return (ValidateQueryRequestBuilder)new ValidateQueryRequestBuilder(this).setIndices(indices);
    }

    public void getSettings(GetSettingsRequest request, ActionListener<GetSettingsResponse> listener) {
        this.execute(GetSettingsAction.INSTANCE, request, listener);
    }

    public ActionFuture<GetSettingsResponse> getSettings(GetSettingsRequest request) {
        return this.execute(GetSettingsAction.INSTANCE, request);
    }

    public GetSettingsRequestBuilder prepareGetSettings(String ... indices) {
        return new GetSettingsRequestBuilder((ElasticsearchClient)this, indices);
    }

    public ResizeRequestBuilder prepareResizeIndex(String sourceIndex, String targetIndex) {
        return new ResizeRequestBuilder(this).setSourceIndex(sourceIndex).setTargetIndex(new CreateIndexRequest(targetIndex));
    }

    public void resizeIndex(ResizeRequest request, ActionListener<CreateIndexResponse> listener) {
        this.execute(ResizeAction.INSTANCE, request, listener);
    }

    public RolloverRequestBuilder prepareRolloverIndex(String alias) {
        return new RolloverRequestBuilder(this).setRolloverTarget(alias);
    }

    public ActionFuture<RolloverResponse> rolloverIndex(RolloverRequest request) {
        return this.execute(RolloverAction.INSTANCE, request);
    }

    public void rolloverIndex(RolloverRequest request, ActionListener<RolloverResponse> listener) {
        this.execute(RolloverAction.INSTANCE, request, listener);
    }

    public void resolveIndex(ResolveIndexAction.Request request, ActionListener<ResolveIndexAction.Response> listener) {
        this.execute(ResolveIndexAction.INSTANCE, request, listener);
    }

    public ActionFuture<ResolveIndexAction.Response> resolveIndex(ResolveIndexAction.Request request) {
        return this.execute(ResolveIndexAction.INSTANCE, request);
    }
}

