/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Security;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.Version;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ReleaseVersions;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.bootstrap.Bootstrap;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapChecks;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.bootstrap.ConsoleLoader;
import org.elasticsearch.bootstrap.ElasticsearchProcess;
import org.elasticsearch.bootstrap.ElasticsearchUncaughtExceptionHandler;
import org.elasticsearch.bootstrap.ScopeResolver;
import org.elasticsearch.bootstrap.ServerArgs;
import org.elasticsearch.bootstrap.Spawner;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.network.IfConfig;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.bootstrap.EntitlementBootstrap;
import org.elasticsearch.entitlement.runtime.api.NotEntitledException;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.entitlement.runtime.policy.PolicyUtils;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.entitlement.runtime.policy.entitlements.LoadNativeLibrariesEntitlement;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.monitor.jvm.HotThreads;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.nativeaccess.WindowsFunctions;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.PluginBundle;
import org.elasticsearch.plugins.PluginsLoader;
import org.elasticsearch.rest.MethodHandlers;
import org.elasticsearch.transport.RequestHandlerRegistry;

class Elasticsearch {
    private static final String POLICY_PATCH_PREFIX = "es.entitlements.policy.";
    private static final String SERVER_POLICY_PATCH_NAME = "es.entitlements.policy.server";
    private static final String APM_AGENT_PACKAGE_NAME = "co.elastic.apm.agent";
    private static volatile Elasticsearch INSTANCE;
    private final Spawner spawner;
    private final Node node;
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Thread keepAliveThread;

    public static void main(String[] args) {
        Bootstrap bootstrap = Elasticsearch.initPhase1();
        assert (bootstrap != null);
        try {
            Elasticsearch.initPhase2(bootstrap);
            Elasticsearch.initPhase3(bootstrap);
        }
        catch (NodeValidationException e) {
            bootstrap.exitWithNodeValidationException(e);
        }
        catch (Throwable t) {
            bootstrap.exitWithUnknownException(t);
        }
    }

    @SuppressForbidden(reason="grab stderr for communication with server-cli")
    private static PrintStream getStderr() {
        return System.err;
    }

    @SuppressForbidden(reason="grab stdout for communication with server-cli")
    private static PrintStream getStdout() {
        return System.out;
    }

    private static Bootstrap initPhase1() {
        ServerArgs args;
        PrintStream out = Elasticsearch.getStdout();
        PrintStream err = Elasticsearch.getStderr();
        try {
            Elasticsearch.initSecurityProperties();
            LogConfigurator.registerErrorListener();
            BootstrapInfo.init();
            InputStreamStreamInput in = new InputStreamStreamInput(System.in);
            args = new ServerArgs(in);
            Environment nodeEnv = new Environment(args.nodeSettings(), args.configDir());
            BootstrapInfo.setConsole(ConsoleLoader.loadConsole(nodeEnv));
            LogConfigurator.setNodeName(Node.NODE_NAME_SETTING.get(args.nodeSettings()));
            LogConfigurator.configure(nodeEnv, !args.quiet());
        }
        catch (Throwable t) {
            t.printStackTrace(err);
            err.flush();
            Bootstrap.exit(1);
            return null;
        }
        return new Bootstrap(out, err, args);
    }

    private static void initPhase2(Bootstrap bootstrap) throws IOException {
        Elasticsearch.logSystemInfo();
        ServerArgs args = bootstrap.args();
        SecureSettings secrets = args.secrets();
        bootstrap.setSecureSettings(secrets);
        Environment nodeEnv = Elasticsearch.createEnvironment(args.configDir(), args.nodeSettings(), secrets);
        bootstrap.setEnvironment(nodeEnv);
        Elasticsearch.initPidFile(args.pidFile());
        Thread.setDefaultUncaughtExceptionHandler(new ElasticsearchUncaughtExceptionHandler());
        bootstrap.spawner().spawnNativeControllers(nodeEnv);
        nodeEnv.validateNativesConfig();
        Elasticsearch.initializeNatives(nodeEnv.tmpDir(), BootstrapSettings.MEMORY_LOCK_SETTING.get(args.nodeSettings()), true, BootstrapSettings.CTRLHANDLER_SETTING.get(args.nodeSettings()));
        Elasticsearch.initializeProbes();
        Runtime.getRuntime().addShutdownHook(new Thread(Elasticsearch::shutdown, "elasticsearch-shutdown"));
        Logger logger = LogManager.getLogger(JarHell.class);
        JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        IfConfig.logIfNecessary();
        Elasticsearch.ensureInitialized(TermsEnum.class, ReleaseVersions.class, ReferenceDocs.class, AbstractRefCounted.class, SubscribableListener.class, RunOnce.class, VectorUtil.class, RequestHandlerRegistry.class, MethodHandlers.class);
        Set<PluginBundle> modulesBundles = PluginsLoader.loadModulesBundles(nodeEnv.modulesDir());
        Set<PluginBundle> pluginsBundles = PluginsLoader.loadPluginsBundles(nodeEnv.pluginsDir());
        LogManager.getLogger(Elasticsearch.class).info("Bootstrapping Entitlements");
        List<PolicyUtils.PluginData> pluginData = Stream.concat(modulesBundles.stream().map(bundle -> new PolicyUtils.PluginData(bundle.getDir(), bundle.pluginDescriptor().isModular(), false)), pluginsBundles.stream().map(bundle -> new PolicyUtils.PluginData(bundle.getDir(), bundle.pluginDescriptor().isModular(), true))).toList();
        Map<String, String> pluginPolicyPatches = Elasticsearch.collectPluginPolicyPatches(modulesBundles, pluginsBundles, logger);
        Map pluginPolicies = PolicyUtils.createPluginPolicies(pluginData, pluginPolicyPatches, (String)Build.current().version());
        Policy serverPolicyPatch = PolicyUtils.parseEncodedPolicyIfExists((String)System.getProperty(SERVER_POLICY_PATCH_NAME), (String)Build.current().version(), (boolean)false, (String)"server", PolicyManager.SERVER_LAYER_MODULES.stream().map(Module::getName).collect(Collectors.toUnmodifiableSet()));
        PluginsLoader pluginsLoader = PluginsLoader.createPluginsLoader(modulesBundles, pluginsBundles, Elasticsearch.findPluginsWithNativeAccess(pluginPolicies));
        ScopeResolver scopeResolver = ScopeResolver.create(pluginsLoader.pluginLayers(), APM_AGENT_PACKAGE_NAME);
        Map<String, Collection> pluginSourcePaths = Stream.concat(modulesBundles.stream(), pluginsBundles.stream()).collect(Collectors.toUnmodifiableMap(bundle -> bundle.pluginDescriptor().getName(), bundle -> List.of(bundle.getDir())));
        EntitlementBootstrap.bootstrap((Policy)serverPolicyPatch, (Map)pluginPolicies, scopeResolver::resolveClassToScope, nodeEnv.settings()::getValues, (Path[])nodeEnv.dataDirs(), (Path)nodeEnv.sharedDataDir(), (Path[])nodeEnv.repoDirs(), (Path)nodeEnv.configDir(), (Path)nodeEnv.libDir(), (Path)nodeEnv.modulesDir(), (Path)nodeEnv.pluginsDir(), pluginSourcePaths, (Path)nodeEnv.logsDir(), (Path)nodeEnv.tmpDir(), (Path)args.pidFile(), Set.of(EntitlementSelfTester.class.getPackage()));
        Elasticsearch.entitlementSelfTest();
        bootstrap.setPluginsLoader(pluginsLoader);
    }

    private static void logSystemInfo() {
        Logger logger = LogManager.getLogger(Elasticsearch.class);
        logger.info("version[{}], pid[{}], build[{}/{}/{}], OS[{}/{}/{}], JVM[{}/{}/{}/{}]", new Object[]{Build.current().qualifiedVersion(), ProcessHandle.current().pid(), Build.current().type().displayName(), Build.current().hash(), Build.current().date(), Constants.OS_NAME, Constants.OS_VERSION, Constants.OS_ARCH, Constants.JVM_VENDOR, Constants.JVM_NAME, System.getProperty("java.version"), Runtime.version().toString()});
        boolean isBundledJdk = System.getProperty("es.java.type", "").equals("bundled JDK");
        logger.info("JVM home [{}], using bundled JDK [{}]", (Object)System.getProperty("java.home"), (Object)isBundledJdk);
        logger.info("JVM arguments {}", ManagementFactory.getRuntimeMXBean().getInputArguments());
        logger.info("Default Locale [{}]", (Object)Locale.getDefault());
        if (!Build.current().isProductionRelease()) {
            logger.warn("version [{}] is a pre-release version of Elasticsearch and is not suitable for production", (Object)Build.current().qualifiedVersion());
        }
    }

    static void entitlementSelfTest() {
        EntitlementSelfTester.entitlementSelfTest();
    }

    private static Map<String, String> collectPluginPolicyPatches(Set<PluginBundle> modulesBundles, Set<PluginBundle> pluginsBundles, Logger logger) {
        HashMap<String, String> policyPatches = new HashMap<String, String>();
        Dictionary<Object, Object> systemProperties = BootstrapInfo.getSystemProperties();
        systemProperties.keys().asIterator().forEachRemaining(key -> {
            Object value = systemProperties.get(key);
            if (key instanceof String) {
                String k = (String)key;
                if (value instanceof String) {
                    String v = (String)value;
                    if (k.startsWith(POLICY_PATCH_PREFIX) && !k.equals(SERVER_POLICY_PATCH_NAME)) {
                        policyPatches.put(k.substring(POLICY_PATCH_PREFIX.length()), v);
                    }
                }
            }
        });
        Set pluginNames = Stream.concat(modulesBundles.stream(), pluginsBundles.stream()).map(bundle -> bundle.pluginDescriptor().getName()).collect(Collectors.toUnmodifiableSet());
        for (String patchedPluginName : policyPatches.keySet()) {
            if (pluginNames.contains(patchedPluginName)) continue;
            logger.warn("Found command-line policy patch for unknown plugin [{}] (available plugins: [{}])", (Object)patchedPluginName, (Object)String.join((CharSequence)", ", pluginNames));
        }
        return policyPatches;
    }

    private static void ensureInitialized(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            try {
                MethodHandles.publicLookup().ensureInitialized(clazz);
            }
            catch (IllegalAccessException unexpected) {
                throw new AssertionError((Object)unexpected);
            }
        }
    }

    private static void initPhase3(Bootstrap bootstrap) throws IOException, NodeValidationException {
        Elasticsearch.checkLucene();
        Node node = new Node(bootstrap.environment(), bootstrap.pluginsLoader()){

            @Override
            protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> checks) throws NodeValidationException {
                BootstrapChecks.check(context, boundTransportAddress, checks);
            }
        };
        INSTANCE = new Elasticsearch(bootstrap.spawner(), node);
        IOUtils.close((Closeable)bootstrap.secureSettings());
        INSTANCE.start();
        if (bootstrap.args().daemonize()) {
            LogConfigurator.removeConsoleAppender();
        }
        bootstrap.sendCliMarker('\u0018');
        if (bootstrap.args().daemonize()) {
            bootstrap.closeStreams();
        } else {
            Elasticsearch.startCliMonitorThread(System.in);
        }
    }

    static void initializeNatives(Path tmpFile, boolean mlockAll, boolean systemCallFilter, boolean ctrlHandler) {
        WindowsFunctions windowsFunctions;
        Logger logger = LogManager.getLogger(Elasticsearch.class);
        NativeAccess nativeAccess = NativeAccess.instance();
        if (nativeAccess.definitelyRunningAsRoot()) {
            throw new RuntimeException("can not run elasticsearch as root");
        }
        if (systemCallFilter) {
            nativeAccess.tryInstallExecSandbox();
        }
        if (mlockAll) {
            nativeAccess.tryLockMemory();
        }
        if (ctrlHandler && (windowsFunctions = nativeAccess.getWindowsFunctions()) != null) {
            windowsFunctions.addConsoleCtrlHandler(code -> {
                if (2 == code) {
                    logger.info("running graceful exit on windows");
                    Elasticsearch.shutdown();
                    return true;
                }
                return false;
            });
        }
        if (IOUtils.LINUX) {
            Elasticsearch.setCoredumpFilter();
        }
        StringHelper.randomId();
    }

    static void initializeProbes() {
        ProcessProbe.getInstance();
        OsProbe.getInstance();
        JvmInfo.jvmInfo();
        HotThreads.initializeRuntimeMonitoring();
    }

    static void checkLucene() {
        if (!IndexVersion.current().luceneVersion().equals((Object)Version.LATEST)) {
            throw new AssertionError((Object)("Lucene version mismatch this version of Elasticsearch requires lucene version [" + String.valueOf(IndexVersion.current().luceneVersion()) + "]  but the current lucene version is [" + String.valueOf(Version.LATEST) + "]"));
        }
    }

    private static void startCliMonitorThread(InputStream stdin) {
        new Thread(() -> {
            int msg = -1;
            try {
                msg = stdin.read();
            }
            catch (IOException iOException) {
            }
            finally {
                if (msg == 27) {
                    Bootstrap.exit(0);
                } else {
                    Bootstrap.exit(1);
                }
            }
        }, "elasticsearch-cli-monitor-thread").start();
    }

    private static void initPidFile(Path pidFile) throws IOException {
        if (pidFile == null) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.deleteIfExists(pidFile);
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to delete pid file " + String.valueOf(pidFile), (Throwable)e, new Object[0]);
            }
        }, "elasticsearch[pidfile-cleanup]"));
        assert (pidFile.isAbsolute());
        if (!Files.exists(pidFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(pidFile.getParent(), new FileAttribute[0]);
        }
        Files.writeString(pidFile, (CharSequence)Long.toString(ProcessHandle.current().pid()), new OpenOption[0]);
    }

    private static void initSecurityProperties() {
        for (String property : new String[]{"networkaddress.cache.ttl", "networkaddress.cache.negative.ttl"}) {
            String overrideProperty = "es." + property;
            String overrideValue = System.getProperty(overrideProperty);
            if (overrideValue == null) continue;
            try {
                Security.setProperty(property, Integer.toString(Integer.valueOf(overrideValue)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [" + overrideProperty + "] with value [" + overrideValue + "]", e);
            }
        }
    }

    private static Environment createEnvironment(Path configDir, Settings initialSettings, SecureSettings secureSettings) {
        Settings.Builder builder = Settings.builder();
        builder.put(initialSettings);
        if (secureSettings != null) {
            builder.setSecureSettings(secureSettings);
        }
        return new Environment(builder.build(), configDir);
    }

    static Map<String, Set<String>> findPluginsWithNativeAccess(Map<String, Policy> policies) {
        HashMap<String, Set<String>> pluginsWithNativeAccess = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Policy> kv : policies.entrySet()) {
            for (Scope scope : kv.getValue().scopes()) {
                if (!scope.entitlements().stream().anyMatch(entitlement -> entitlement instanceof LoadNativeLibrariesEntitlement)) continue;
                Set modulesToEnable = pluginsWithNativeAccess.computeIfAbsent(kv.getKey(), k -> new HashSet());
                modulesToEnable.add(scope.moduleName());
            }
        }
        return pluginsWithNativeAccess;
    }

    @SuppressForbidden(reason="access proc filesystem")
    private static void setCoredumpFilter() {
        try {
            Files.writeString(Path.of("/proc/self/coredump_filter", new String[0]), (CharSequence)"0x23", new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not set coredump filter", e);
        }
    }

    private Elasticsearch(Spawner spawner, Node node) {
        this.spawner = Objects.requireNonNull(spawner);
        this.node = Objects.requireNonNull(node);
        this.keepAliveThread = new Thread(() -> {
            try {
                this.keepAliveLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, "elasticsearch[keepAlive/" + Build.current().version() + "]");
    }

    private void start() throws NodeValidationException {
        this.node.start();
        this.keepAliveThread.start();
    }

    private static void shutdown() {
        ElasticsearchProcess.markStopping();
        if (INSTANCE == null) {
            return;
        }
        Elasticsearch es = INSTANCE;
        try {
            es.node.prepareForClose();
            IOUtils.close((Closeable[])new Closeable[]{es.node, es.spawner});
            if (!es.node.awaitClose(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchException("Failure occurred while shutting down node", (Throwable)ex, new Object[0]);
        }
        catch (InterruptedException e) {
            LogManager.getLogger(Elasticsearch.class).warn("Thread got interrupted while waiting for the node to shutdown.");
            Thread.currentThread().interrupt();
        }
        finally {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configurator.shutdown((LoggerContext)context);
            es.keepAliveLatch.countDown();
        }
    }

    private static class EntitlementSelfTester {
        private EntitlementSelfTester() {
        }

        private static void entitlementSelfTest() {
            EntitlementSelfTester.ensureCannotStartProcess(ProcessBuilder::start);
            EntitlementSelfTester.ensureCannotStartProcess(EntitlementSelfTester::reflectiveStartProcess);
        }

        private static void ensureCannotStartProcess(CheckedConsumer<ProcessBuilder, ?> startProcess) {
            try {
                startProcess.accept((Object)new ProcessBuilder(""));
            }
            catch (NotEntitledException e) {
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed entitlement protection self-test", e);
            }
            throw new IllegalStateException("Entitlement protection self-test was incorrectly permitted");
        }

        private static void reflectiveStartProcess(ProcessBuilder pb) throws Exception {
            try {
                Method start = ProcessBuilder.class.getMethod("start", new Class[0]);
                start.invoke((Object)pb, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getCause();
            }
        }
    }
}

