/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.reservedstate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class ReservedRepositoryAction
implements ReservedClusterStateHandler<List<PutRepositoryRequest>> {
    public static final String NAME = "snapshot_repositories";
    private final RepositoriesService repositoriesService;

    public ReservedRepositoryAction(RepositoriesService repositoriesService) {
        this.repositoriesService = repositoriesService;
    }

    @Override
    public String name() {
        return NAME;
    }

    public Collection<PutRepositoryRequest> prepare(Object input) {
        List repositories = (List)input;
        for (PutRepositoryRequest repositoryRequest : repositories) {
            this.validate(repositoryRequest);
            RepositoriesService.validateRepositoryName(repositoryRequest.name());
            this.repositoriesService.validateRepositoryCanBeCreated(repositoryRequest);
        }
        return repositories;
    }

    @Override
    public TransformState transform(Object source, TransformState prevState) throws Exception {
        Collection<PutRepositoryRequest> requests = this.prepare(source);
        ClusterState state = prevState.state();
        for (PutRepositoryRequest request : requests) {
            RepositoriesService.RegisterRepositoryTask task = new RepositoriesService.RegisterRepositoryTask(this.repositoriesService, request);
            state = task.execute(state);
        }
        Set<String> entities = requests.stream().map(r -> r.name()).collect(Collectors.toSet());
        HashSet<String> toDelete = new HashSet<String>(prevState.keys());
        toDelete.removeAll(entities);
        for (String repositoryToDelete : toDelete) {
            RepositoriesService.UnregisterRepositoryTask task = new RepositoriesService.UnregisterRepositoryTask(DUMMY_TIMEOUT, repositoryToDelete);
            state = task.execute(state);
        }
        return new TransformState(state, entities);
    }

    @Override
    public ClusterState remove(TransformState prevState) throws Exception {
        return this.transform(List.of(), prevState).state();
    }

    @Override
    public List<PutRepositoryRequest> fromXContent(XContentParser parser) throws IOException {
        ArrayList<PutRepositoryRequest> result = new ArrayList<PutRepositoryRequest>();
        Map source = parser.map();
        for (Map.Entry entry : source.entrySet()) {
            PutRepositoryRequest putRepositoryRequest = new PutRepositoryRequest(DUMMY_TIMEOUT, DUMMY_TIMEOUT, (String)entry.getKey());
            Map content = (Map)entry.getValue();
            try (XContentParser repoParser = XContentHelper.mapToXContentParser(XContentParserConfiguration.EMPTY, content);){
                putRepositoryRequest.source(repoParser.mapOrdered());
            }
            result.add(putRepositoryRequest);
        }
        return result;
    }
}

