/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoMetrics;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;

public final class NodesInfoRequest
extends BaseNodesRequest<NodesInfoRequest> {
    private final NodesInfoMetrics nodesInfoMetrics = new NodesInfoMetrics();

    public NodesInfoRequest(String ... nodesIds) {
        super(nodesIds);
        this.all();
    }

    public NodesInfoRequest clear() {
        this.nodesInfoMetrics.requestedMetrics().clear();
        return this;
    }

    public NodesInfoRequest all() {
        this.nodesInfoMetrics.requestedMetrics().addAll(NodesInfoMetrics.Metric.allMetrics());
        return this;
    }

    public Set<String> requestedMetrics() {
        return Set.copyOf(this.nodesInfoMetrics.requestedMetrics());
    }

    public NodesInfoRequest addMetric(String metric) {
        if (!NodesInfoMetrics.Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.nodesInfoMetrics.requestedMetrics().add(metric);
        return this;
    }

    public NodesInfoRequest addMetrics(String ... metrics) {
        TreeSet<String> metricsSet = new TreeSet<String>(Set.of(metrics));
        return this.addMetrics(metricsSet);
    }

    public NodesInfoRequest addMetrics(Set<String> metricsSet) {
        if (!NodesInfoMetrics.Metric.allMetrics().containsAll(metricsSet)) {
            metricsSet.removeAll(NodesInfoMetrics.Metric.allMetrics());
            String plural = metricsSet.size() == 1 ? "" : "s";
            throw new IllegalStateException("Used illegal metric" + plural + ": " + String.valueOf(metricsSet));
        }
        this.nodesInfoMetrics.requestedMetrics().addAll(metricsSet);
        return this;
    }

    public NodesInfoRequest removeMetric(String metric) {
        if (!NodesInfoMetrics.Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.nodesInfoMetrics.requestedMetrics().remove(metric);
        return this;
    }

    public NodesInfoMetrics getNodesInfoMetrics() {
        return this.nodesInfoMetrics;
    }
}

