/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.go.api.checks;

import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.utils.Version;

public class GoVersion {
    public static final GoVersion UNKNOWN_VERSION = new GoVersion(null);
    private final Version version;

    public static GoVersion parse(@Nullable String version) {
        if (version == null) {
            return UNKNOWN_VERSION;
        }
        try {
            return new GoVersion(Version.parse((String)version));
        }
        catch (NumberFormatException e) {
            return UNKNOWN_VERSION;
        }
    }

    private GoVersion(@Nullable Version version) {
        this.version = version;
    }

    public boolean isUnknownVersion() {
        return this.version == null;
    }

    public boolean isGreaterThanEqualOrUnknown(GoVersion otherVersion) {
        if (this.isUnknownVersion() || otherVersion.isUnknownVersion()) {
            return true;
        }
        return this.version.isGreaterThanOrEqual(otherVersion.version);
    }

    public String toString() {
        if (this.version == null) {
            return "unknown";
        }
        return this.version.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.version, ((GoVersion)o).version);
    }

    public int hashCode() {
        return Objects.hashCode(this.version);
    }
}

