/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.go.api.checks;

import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.GoModFileData;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

public interface CheckContext {
    public Deque<Tree> ancestors();

    @CheckForNull
    default public Tree parent() {
        if (this.ancestors().isEmpty()) {
            return null;
        }
        return this.ancestors().peek();
    }

    default public <T extends Tree> Optional<T> firstAncestorOfKind(Class<T> type) {
        return this.ancestors().stream().filter(type::isInstance).map(type::cast).findFirst();
    }

    public String filename();

    public InputFile inputFile();

    public String fileContent();

    public GoModFileData goModFileData();

    public void reportIssue(TextRange var1, String var2);

    public void reportIssue(HasTextRange var1, String var2);

    public void reportIssue(HasTextRange var1, String var2, SecondaryLocation var3);

    public void reportIssue(HasTextRange var1, String var2, List<SecondaryLocation> var3);

    public void reportIssue(HasTextRange var1, String var2, List<SecondaryLocation> var3, @Nullable Double var4);

    public void reportFileIssue(String var1);

    public void reportFileIssue(String var1, @Nullable Double var2);
}

