/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonar.go.visitors.TreeContext;
import org.sonar.plugins.go.api.Tree;

public class TreeVisitor<C extends TreeContext> {
    private List<ConsumerFilter<C, ?>> consumersOnEnterTree = new ArrayList();
    private List<ConsumerFilter<C, ?>> consumersOnLeaveTree = new ArrayList();

    public void scan(C ctx, @Nullable Tree root) {
        if (root != null) {
            ((TreeContext)ctx).before(root);
            this.before(ctx, root);
            this.visit(ctx, root);
            this.after(ctx, root);
        }
    }

    private void visit(C ctx, @Nullable Tree node) {
        if (node != null) {
            ((TreeContext)ctx).enter(node);
            this.callConsumers(ctx, node, this.consumersOnEnterTree);
            node.children().forEach(child -> this.visit(ctx, (Tree)child));
            this.callConsumers(ctx, node, this.consumersOnLeaveTree);
            ((TreeContext)ctx).leave(node);
        }
    }

    private void callConsumers(C ctx, Tree node, List<ConsumerFilter<C, ?>> consumerList) {
        for (ConsumerFilter<C, ?> consumer : consumerList) {
            consumer.accept(ctx, node);
        }
    }

    protected void before(C ctx, Tree root) {
    }

    protected void after(C ctx, Tree root) {
    }

    public <T extends Tree> TreeVisitor<C> register(Class<T> cls, BiConsumer<C, T> visitor) {
        this.consumersOnEnterTree.add(new ConsumerFilter<C, T>(cls, visitor));
        return this;
    }

    public <T extends Tree> TreeVisitor<C> registerOnLeaveTree(Class<T> cls, BiConsumer<C, T> visitor) {
        this.consumersOnLeaveTree.add(new ConsumerFilter<C, T>(cls, visitor));
        return this;
    }

    private static class ConsumerFilter<C extends TreeContext, T extends Tree> {
        private final Class<T> cls;
        private final BiConsumer<C, T> delegate;

        private ConsumerFilter(Class<T> cls, BiConsumer<C, T> delegate) {
            this.cls = cls;
            this.delegate = delegate;
        }

        private void accept(C ctx, Tree node) {
            if (this.cls.isAssignableFrom(node.getClass())) {
                this.delegate.accept(ctx, (Tree)this.cls.cast(node));
            }
        }
    }
}

