/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.visitors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.go.impl.IdentifierTreeImpl;
import org.sonar.go.symbols.Symbol;
import org.sonar.go.symbols.Usage;
import org.sonar.go.utils.VariableHelper;
import org.sonar.go.visitors.TreeContext;
import org.sonar.go.visitors.TreeVisitor;
import org.sonar.plugins.go.api.AssignmentExpressionTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.LeftRightHandSideTree;
import org.sonar.plugins.go.api.ParameterTree;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.VariableDeclarationTree;

public class SymbolVisitor<C extends TreeContext>
extends TreeVisitor<C> {
    private final Map<Integer, Symbol> symbolTable = new HashMap<Integer, Symbol>();

    public SymbolVisitor() {
        this.register(VariableDeclarationTree.class, (ctx, variableDeclarationTree) -> VariableHelper.getVariables(variableDeclarationTree).forEach(variable -> this.addVariable(variable.identifier(), variable.value(), Usage.UsageType.DECLARATION)));
        this.register(ParameterTree.class, (ctx, parameterTree) -> this.addVariable(parameterTree.identifier(), null, Usage.UsageType.PARAMETER));
        this.register(AssignmentExpressionTree.class, this::processAssignment);
        this.register(IdentifierTreeImpl.class, this::processIdentifier);
        this.registerOnLeaveTree(TopLevelTree.class, (ctx, tree) -> this.symbolTable.clear());
    }

    private void addVariable(IdentifierTree identifier, @Nullable Tree value, Usage.UsageType type) {
        if (identifier.id() != 0) {
            this.symbolTable.computeIfAbsent(identifier.id(), id -> new Symbol(identifier.type()));
            this.addVariableUsage(identifier, value, type);
        }
    }

    private void processIdentifier(C context, IdentifierTreeImpl identifier) {
        if (identifier.symbol() == null) {
            this.addVariableUsage(identifier, null, Usage.UsageType.REFERENCE);
        }
    }

    private void processAssignment(C context, AssignmentExpressionTree assignmentExpression) {
        Tree leftHandSide = assignmentExpression.leftHandSide();
        List<IdentifierTree> identifiers = SymbolVisitor.extractIdentifiers(leftHandSide);
        if (SymbolVisitor.isLeftOrRightHandSide(assignmentExpression.statementOrExpression()) && leftHandSide instanceof LeftRightHandSideTree) {
            LeftRightHandSideTree left = (LeftRightHandSideTree)leftHandSide;
            List<Tree> values = left.getChildrenSkipEmptyNativeTrees();
            for (int i = 0; i < identifiers.size(); ++i) {
                this.addVariableUsage(identifiers.get(i), values.get(i), Usage.UsageType.ASSIGNMENT);
            }
        } else {
            for (IdentifierTree identifier : identifiers) {
                this.addVariableUsage(identifier, assignmentExpression.statementOrExpression(), Usage.UsageType.ASSIGNMENT);
            }
        }
    }

    private static List<IdentifierTree> extractIdentifiers(Tree tree) {
        if (tree instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)tree;
            return List.of(identifier);
        }
        if (tree instanceof LeftRightHandSideTree) {
            LeftRightHandSideTree leftRightHandSide = (LeftRightHandSideTree)tree;
            return leftRightHandSide.extractIdentifiers();
        }
        return Collections.emptyList();
    }

    private static boolean isLeftOrRightHandSide(Tree tree) {
        return tree instanceof LeftRightHandSideTree;
    }

    private void addVariableUsage(IdentifierTree identifier, @Nullable Tree value, Usage.UsageType type) {
        Symbol symbol;
        if (identifier.id() != 0 && (symbol = this.symbolTable.get(identifier.id())) != null) {
            symbol.getUsages().add(new Usage(identifier, value, type));
            identifier.setSymbol(symbol);
        }
    }
}

