/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.utils;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.go.utils.NativeKinds;
import org.sonar.plugins.go.api.FunctionInvocationTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.MemberSelectTree;
import org.sonar.plugins.go.api.Tree;

public class TreeUtils {
    public static final Predicate<Tree> IS_NOT_SEMICOLON = Predicate.not(tree -> NativeKinds.isStringNativeKindOfType(tree, "Semicolon"));
    public static final Predicate<Tree> IS_NOT_EMPTY_NATIVE_TREE = Predicate.not(tree -> NativeKinds.isStringNativeKindOfType(tree, ""));

    private TreeUtils() {
    }

    public static <T extends Tree> List<String> getIdentifierNames(List<T> trees) {
        return trees.stream().filter(IdentifierTree.class::isInstance).map(IdentifierTree.class::cast).map(IdentifierTree::name).toList();
    }

    public static <T extends Tree> String getIdentifierName(List<T> trees) {
        return trees.stream().filter(IdentifierTree.class::isInstance).map(IdentifierTree.class::cast).map(IdentifierTree::name).collect(Collectors.joining("."));
    }

    public static Optional<IdentifierTree> retrieveFirstIdentifier(Tree tree) {
        if (tree instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)tree;
            return Optional.of(identifierTree);
        }
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
            return TreeUtils.retrieveFirstIdentifier(memberSelectTree.expression());
        }
        if (tree instanceof FunctionInvocationTree) {
            FunctionInvocationTree functionInvocationTree = (FunctionInvocationTree)tree;
            return TreeUtils.retrieveFirstIdentifier(functionInvocationTree.memberSelect());
        }
        return Optional.empty();
    }

    public static Optional<IdentifierTree> retrieveLastIdentifier(Tree tree) {
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
            return Optional.of(memberSelectTree.identifier());
        }
        if (tree instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)tree;
            return Optional.of(identifierTree);
        }
        return Optional.empty();
    }
}

