/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.go.visitors.TreePrinter;
import org.sonar.plugins.go.api.AssignmentExpressionTree;
import org.sonar.plugins.go.api.BinaryExpressionTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.JumpTree;
import org.sonar.plugins.go.api.LiteralTree;
import org.sonar.plugins.go.api.LoopTree;
import org.sonar.plugins.go.api.ModifierTree;
import org.sonar.plugins.go.api.NativeTree;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.UnaryExpressionTree;
import org.sonar.plugins.go.api.VariableDeclarationTree;

public class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(@Nullable List<? extends Tree> first, @Nullable List<? extends Tree> second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null || first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (SyntacticEquivalence.areEquivalent(first.get(i), second.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(@Nullable Tree first, @Nullable Tree second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null || !first.getClass().equals(second.getClass())) {
            return false;
        }
        if (first instanceof IdentifierTree) {
            return SyntacticEquivalence.getUniqueIdentifier((IdentifierTree)first).equals(SyntacticEquivalence.getUniqueIdentifier((IdentifierTree)second));
        }
        if (first instanceof LiteralTree) {
            return ((LiteralTree)first).value().equals(((LiteralTree)second).value());
        }
        if (SyntacticEquivalence.hasDifferentFields(first, second)) {
            return false;
        }
        if (first instanceof NativeTree && first.children().isEmpty()) {
            return SyntacticEquivalence.areEquivalentTokenText(first.metaData().tokens(), second.metaData().tokens());
        }
        return SyntacticEquivalence.areEquivalent(first.children(), second.children());
    }

    public static String getUniqueIdentifier(IdentifierTree identifier) {
        return identifier.identifier();
    }

    private static boolean areEquivalentTokenText(List<Token> firstList, List<Token> secondList) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        for (int i = 0; i < firstList.size(); ++i) {
            if (firstList.get(i).text().equals(secondList.get(i).text())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasDifferentFields(Tree first, Tree second) {
        boolean nativeTreeCheck = first instanceof NativeTree && !((NativeTree)first).nativeKind().equals(((NativeTree)second).nativeKind());
        boolean unaryTreeCheck = first instanceof UnaryExpressionTree && ((UnaryExpressionTree)first).operator() != ((UnaryExpressionTree)second).operator();
        boolean binaryTreeCheck = first instanceof BinaryExpressionTree && ((BinaryExpressionTree)first).operator() != ((BinaryExpressionTree)second).operator();
        boolean assignTreeCheck = first instanceof AssignmentExpressionTree && ((AssignmentExpressionTree)first).operator() != ((AssignmentExpressionTree)second).operator();
        boolean vardeclTreeCheck = first instanceof VariableDeclarationTree && ((VariableDeclarationTree)first).isVal() != ((VariableDeclarationTree)second).isVal();
        boolean loopTreeCheck = first instanceof LoopTree && (((LoopTree)first).kind() != ((LoopTree)second).kind() || !((LoopTree)first).keyword().text().equals(((LoopTree)second).keyword().text()));
        boolean modifierTreeCheck = first instanceof ModifierTree && ((ModifierTree)first).kind() != ((ModifierTree)second).kind();
        boolean jumpTreeCheck = first instanceof JumpTree && ((JumpTree)first).kind() != ((JumpTree)second).kind();
        return nativeTreeCheck || unaryTreeCheck || binaryTreeCheck || assignTreeCheck || vardeclTreeCheck || loopTreeCheck || modifierTreeCheck || jumpTreeCheck;
    }

    public static List<List<Tree>> findDuplicatedGroups(List<Tree> list) {
        return list.stream().collect(Collectors.groupingBy(ComparableTree::new, LinkedHashMap::new, Collectors.toList())).values().stream().filter(group -> group.size() > 1).toList();
    }

    static class ComparableTree {
        private final Tree tree;
        private final int hash;

        ComparableTree(Tree tree) {
            this.tree = tree;
            this.hash = ComparableTree.computeHash(tree);
        }

        private static int computeHash(@Nullable Tree tree) {
            if (tree == null) {
                return 0;
            }
            return TreePrinter.tree2string(tree).hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableTree)) {
                return false;
            }
            ComparableTree that = (ComparableTree)other;
            return this.hash == that.hash && SyntacticEquivalence.areEquivalent(this.tree, ((ComparableTree)other).tree);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

