/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.utils;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.go.persistence.conversion.StringNativeKind;
import org.sonar.plugins.go.api.NativeKind;
import org.sonar.plugins.go.api.NativeTree;
import org.sonar.plugins.go.api.Tree;

public final class NativeKinds {
    public static final String LABEL = "LabeledStmt";
    public static final String SEMICOLON = "Semicolon";
    public static final Predicate<String> IS_BINARY_EXPR = Pattern.compile("\\[\\d++]\\(BinaryExpr\\)|[A-Z]\\(BinaryExpr\\)").asMatchPredicate();
    public static final String METHOD_RECEIVER_SUFFIX = "]*Ident)";

    private NativeKinds() {
    }

    public static boolean isStringNativeKind(@Nullable Tree tree, Predicate<String> predicate) {
        StringNativeKind stringNativeKind;
        NativeTree nativeTree;
        NativeKind nativeKind;
        return tree instanceof NativeTree && (nativeKind = (nativeTree = (NativeTree)tree).nativeKind()) instanceof StringNativeKind && predicate.test((stringNativeKind = (StringNativeKind)nativeKind).kind());
    }

    public static boolean isStringNativeKindOfType(Tree tree, String type) {
        return NativeKinds.isStringNativeKind(tree, type::equals);
    }

    public static boolean isStringNativeKindOfType(Tree tree, String type, String subtype) {
        return NativeKinds.isStringNativeKind(tree, s -> s.startsWith(type + "(") && s.endsWith(subtype + ")"));
    }

    public static boolean isCompositeLit(Tree tree) {
        StringNativeKind stringNativeKind;
        NativeTree nativeTree;
        NativeKind nativeKind;
        return tree instanceof NativeTree && (nativeKind = (nativeTree = (NativeTree)tree).nativeKind()) instanceof StringNativeKind && (stringNativeKind = (StringNativeKind)nativeKind).kind().contains("CompositeLit");
    }

    public static boolean isKeyValueExpr(Tree tree) {
        StringNativeKind stringNativeKind;
        NativeTree nativeTree;
        NativeKind nativeKind;
        return tree instanceof NativeTree && (nativeKind = (nativeTree = (NativeTree)tree).nativeKind()) instanceof StringNativeKind && (stringNativeKind = (StringNativeKind)nativeKind).kind().contains("KeyValueExpr");
    }

    public static boolean isMethodReceiverTreeIdentifier(Tree tree) {
        StringNativeKind stringNativeKind;
        NativeTree nativeTree;
        NativeKind nativeKind;
        return tree instanceof NativeTree && (nativeKind = (nativeTree = (NativeTree)tree).nativeKind()) instanceof StringNativeKind && (stringNativeKind = (StringNativeKind)nativeKind).kind().endsWith(METHOD_RECEIVER_SUFFIX);
    }
}

