/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.go.impl.TypeImpl;
import org.sonar.plugins.go.api.ArrayTypeTree;
import org.sonar.plugins.go.api.BinaryExpressionTree;
import org.sonar.plugins.go.api.CompositeLiteralTree;
import org.sonar.plugins.go.api.EllipsisTree;
import org.sonar.plugins.go.api.FunctionInvocationTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.KeyValueTree;
import org.sonar.plugins.go.api.LiteralTree;
import org.sonar.plugins.go.api.MapTypeTree;
import org.sonar.plugins.go.api.MemberSelectTree;
import org.sonar.plugins.go.api.ParenthesizedExpressionTree;
import org.sonar.plugins.go.api.PlaceHolderTree;
import org.sonar.plugins.go.api.StarExpressionTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.Type;
import org.sonar.plugins.go.api.UnaryExpressionTree;

public class ExpressionUtils {
    private static final String NIL_LITERAL = "nil";
    private static final String TRUE_LITERAL = "true";
    private static final String FALSE_LITERAL = "false";
    private static final List<String> BOOLEAN_LITERALS = Arrays.asList("true", "false");

    private ExpressionUtils() {
    }

    public static boolean isNilLiteral(@Nullable Tree tree) {
        LiteralTree literalTree;
        return tree instanceof LiteralTree && NIL_LITERAL.equals((literalTree = (LiteralTree)tree).value());
    }

    public static boolean isBooleanLiteral(Tree tree) {
        LiteralTree literalTree;
        return tree instanceof LiteralTree && BOOLEAN_LITERALS.contains((literalTree = (LiteralTree)tree).value());
    }

    public static boolean isFalseValueLiteral(Tree originalTree) {
        LiteralTree literalTree;
        Tree tree = ExpressionUtils.skipParentheses(originalTree);
        return tree instanceof LiteralTree && FALSE_LITERAL.equals((literalTree = (LiteralTree)tree).value()) || ExpressionUtils.isNegation(tree) && ExpressionUtils.isTrueValueLiteral(((UnaryExpressionTree)tree).operand());
    }

    public static boolean isTrueValueLiteral(Tree originalTree) {
        LiteralTree literalTree;
        Tree tree = ExpressionUtils.skipParentheses(originalTree);
        return tree instanceof LiteralTree && TRUE_LITERAL.equals((literalTree = (LiteralTree)tree).value()) || ExpressionUtils.isNegation(tree) && ExpressionUtils.isFalseValueLiteral(((UnaryExpressionTree)tree).operand());
    }

    public static boolean isNegation(Tree tree) {
        UnaryExpressionTree unary;
        return tree instanceof UnaryExpressionTree && (unary = (UnaryExpressionTree)tree).operator() == UnaryExpressionTree.Operator.NEGATE;
    }

    public static boolean isBinaryOperation(Tree tree, BinaryExpressionTree.Operator operator) {
        BinaryExpressionTree binaryExpressionTree;
        return tree instanceof BinaryExpressionTree && (binaryExpressionTree = (BinaryExpressionTree)tree).operator() == operator;
    }

    public static boolean isLogicalBinaryExpression(Tree tree) {
        return ExpressionUtils.isBinaryOperation(tree, BinaryExpressionTree.Operator.CONDITIONAL_AND) || ExpressionUtils.isBinaryOperation(tree, BinaryExpressionTree.Operator.CONDITIONAL_OR);
    }

    public static Tree skipParentheses(@Nullable Tree tree) {
        Tree result = tree;
        while (result instanceof ParenthesizedExpressionTree) {
            ParenthesizedExpressionTree parenthesizedExpressionTree = (ParenthesizedExpressionTree)result;
            result = parenthesizedExpressionTree.expression();
        }
        return result;
    }

    public static boolean containsPlaceHolder(Tree tree) {
        return tree.descendants().anyMatch(PlaceHolderTree.class::isInstance);
    }

    public static Optional<String> getMemberSelectOrIdentifierName(Tree tree) {
        if (tree instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)tree;
            return Optional.of(identifierTree.name());
        }
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
            return Optional.of(memberSelectTree.identifier().name());
        }
        return Optional.empty();
    }

    public static boolean isOfType(MemberSelectTree memberSelectTree, String expectedPackageName, String expectedIdentifierName) {
        IdentifierTree firstIdentifier;
        Tree tree = memberSelectTree.expression();
        return tree instanceof IdentifierTree && expectedPackageName.equals((firstIdentifier = (IdentifierTree)tree).packageName()) && expectedIdentifierName.equals(memberSelectTree.identifier().name());
    }

    public static Optional<Type> getTypeOfInitializer(@Nullable Tree initializer) {
        FunctionInvocationTree invocation;
        if (initializer == null) {
            return Optional.empty();
        }
        if (initializer instanceof FunctionInvocationTree && ExpressionUtils.getMemberSelectOrIdentifierName((invocation = (FunctionInvocationTree)initializer).memberSelect()).filter("new"::equals).isPresent()) {
            return ExpressionUtils.getTypeOfNewExpression(invocation);
        }
        if (initializer instanceof StarExpressionTree) {
            StarExpressionTree starExpressionTree = (StarExpressionTree)initializer;
            return ExpressionUtils.getTypeOfInitializer(starExpressionTree.operand());
        }
        Tree tree = ExpressionUtils.getUnaryOperandOrTree(initializer);
        if (tree instanceof CompositeLiteralTree) {
            CompositeLiteralTree compositeLiteralTree = (CompositeLiteralTree)tree;
            return ExpressionUtils.getTypeOfMemberSelectOrIdentifier(compositeLiteralTree.type());
        }
        return Optional.empty();
    }

    public static Tree getUnaryOperandOrTree(@Nullable Tree tree) {
        UnaryExpressionTree unaryExpression;
        if (tree instanceof UnaryExpressionTree && (unaryExpression = (UnaryExpressionTree)tree).operator() == UnaryExpressionTree.Operator.ADDRESS_OF) {
            return unaryExpression.operand();
        }
        return tree;
    }

    public static Tree getUnaryOperandOfDereferenceOrTree(@Nullable Tree tree) {
        if (tree instanceof StarExpressionTree) {
            StarExpressionTree starExpression = (StarExpressionTree)tree;
            return starExpression.operand();
        }
        return tree;
    }

    private static Optional<Type> getTypeOfNewExpression(FunctionInvocationTree newInvocation) {
        List<Tree> arguments = newInvocation.arguments();
        if (arguments.isEmpty()) {
            return Optional.empty();
        }
        return ExpressionUtils.getTypeOfMemberSelectOrIdentifier(arguments.get(0));
    }

    private static Optional<Type> getTypeOfMemberSelectOrIdentifier(@Nullable Tree tree) {
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
            return Optional.of(new TypeImpl(memberSelectTree.identifier().type(), memberSelectTree.identifier().packageName()));
        }
        if (tree instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)tree;
            return Optional.of(new TypeImpl(identifierTree.type(), identifierTree.packageName()));
        }
        return Optional.empty();
    }

    public static Optional<Tree> retrieveByteArrayCallArg(@Nullable Tree tree) {
        FunctionInvocationTree functionInvocation;
        if (tree instanceof FunctionInvocationTree && !(functionInvocation = (FunctionInvocationTree)tree).arguments().isEmpty() && ExpressionUtils.isByteArray(functionInvocation.memberSelect())) {
            return Optional.of(functionInvocation.arguments().get(0));
        }
        return Optional.empty();
    }

    public static boolean isByteArray(Tree tree) {
        IdentifierTree identifier;
        ArrayTypeTree arrayType;
        Tree tree2;
        return tree instanceof ArrayTypeTree && (tree2 = (arrayType = (ArrayTypeTree)tree).element()) instanceof IdentifierTree && "byte".equals((identifier = (IdentifierTree)tree2).name());
    }

    public static boolean isPointerTypeCast(Tree tree, Predicate<Tree> typePredicate) {
        StarExpressionTree starExpressionTree;
        ParenthesizedExpressionTree parenthesizedExpression;
        FunctionInvocationTree functionInvocation;
        Tree tree2;
        return tree instanceof FunctionInvocationTree && (tree2 = (functionInvocation = (FunctionInvocationTree)tree).memberSelect()) instanceof ParenthesizedExpressionTree && (tree2 = (parenthesizedExpression = (ParenthesizedExpressionTree)tree2).expression()) instanceof StarExpressionTree && typePredicate.test((starExpressionTree = (StarExpressionTree)tree2).operand()) && functionInvocation.arguments().size() == 1;
    }

    public static Optional<Tree> retrieveByteArrayMakeSizeTree(@Nullable Tree tree) {
        IdentifierTree functionName;
        Tree tree2;
        FunctionInvocationTree functionInvocation;
        if (tree instanceof FunctionInvocationTree && (functionInvocation = (FunctionInvocationTree)tree).arguments().size() >= 2 && (tree2 = functionInvocation.memberSelect()) instanceof IdentifierTree && "make".equals((functionName = (IdentifierTree)tree2).name()) && ExpressionUtils.isByteArray(functionInvocation.arguments().get(0))) {
            return Optional.of(functionInvocation.arguments().get(1));
        }
        return Optional.empty();
    }

    public static Optional<Tree> getValueByKeyFromLiteral(CompositeLiteralTree literal, String keyName) {
        return literal.getKeyValuesElements().filter(element -> {
            IdentifierTree identifier;
            Tree patt0$temp = element.key();
            return patt0$temp instanceof IdentifierTree && keyName.equals((identifier = (IdentifierTree)patt0$temp).name());
        }).map(KeyValueTree::value).findFirst();
    }

    public static boolean hasTypeIgnoringStar(IdentifierTree identifier, String type) {
        String identifierType = identifier.type();
        if (identifierType == null) {
            return false;
        }
        if (identifierType.startsWith("*")) {
            identifierType = identifierType.substring(1);
        }
        return identifierType.equals(type);
    }

    public static Type getTypeOfTree(@Nullable Tree tree) {
        return ExpressionUtils.getTypeOfTree("", tree);
    }

    private static Type getTypeOfTree(String typePrefix, @Nullable Tree tree) {
        if (tree instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)tree;
            return new TypeImpl(typePrefix + identifierTree.type(), identifierTree.packageName());
        }
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
            return ExpressionUtils.getTypeOfTree(typePrefix, memberSelectTree.identifier());
        }
        if (tree instanceof StarExpressionTree) {
            StarExpressionTree starExpressionTree = (StarExpressionTree)tree;
            return ExpressionUtils.getTypeOfTree(typePrefix + "*", starExpressionTree.operand());
        }
        if (tree instanceof EllipsisTree) {
            Optional<Tree> id = tree.children().stream().filter(t -> t instanceof IdentifierTree || t instanceof MemberSelectTree || t instanceof StarExpressionTree).findFirst();
            if (id.isPresent()) {
                Tree identifierTree = id.get();
                return ExpressionUtils.getTypeOfTree(typePrefix + "...", identifierTree);
            }
        } else {
            if (tree instanceof ArrayTypeTree) {
                ArrayTypeTree arrayTypeTree = (ArrayTypeTree)tree;
                return arrayTypeTree.type();
            }
            if (tree instanceof MapTypeTree) {
                MapTypeTree mapTypeTree = (MapTypeTree)tree;
                return mapTypeTree.type();
            }
        }
        return TypeImpl.UNKNOWN_TYPE;
    }
}

