/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.symbols;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.go.symbols.Usage;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.Tree;

public class Symbol {
    private final String type;
    private final List<Usage> usages;

    public Symbol(String type) {
        this.type = type;
        this.usages = new ArrayList<Usage>();
    }

    public String getType() {
        return this.type;
    }

    public List<Usage> getUsages() {
        return this.usages;
    }

    public List<Usage> getUsagesBeforeLine(int line) {
        return this.usages.stream().takeWhile(usage -> usage.identifier().textRange().start().line() < line).toList();
    }

    public List<Usage> getUsagesBefore(HasTextRange hasTextRange) {
        return this.getUsagesBeforeLine(hasTextRange.textRange().start().line());
    }

    @CheckForNull
    public Tree getSafeValue() {
        Usage effectivelyFinalUsage = null;
        for (Usage usage : this.usages) {
            if (usage.type() == Usage.UsageType.PARAMETER) {
                return null;
            }
            if (usage.type() == Usage.UsageType.DECLARATION) {
                if (effectivelyFinalUsage != null) {
                    return null;
                }
                if (usage.value() == null) continue;
                effectivelyFinalUsage = usage;
                continue;
            }
            if (usage.type() == Usage.UsageType.ASSIGNMENT && effectivelyFinalUsage == null) {
                effectivelyFinalUsage = usage;
                continue;
            }
            if (usage.type() != Usage.UsageType.ASSIGNMENT) continue;
            return null;
        }
        return effectivelyFinalUsage != null ? effectivelyFinalUsage.value() : null;
    }
}

