/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.report;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.go.plugin.GoFolder;

public class GoProgressReport {
    private static final Logger LOG = LoggerFactory.getLogger(GoProgressReport.class);
    private final long period;
    private final TimeUnit timeUnit;
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduledTask;
    private Iterator<GoFolder> itFolder;
    private long currentFolderIndex;
    private long totalFolders;
    private long totalFiles;
    private GoFolder currentFolder;
    @Nullable
    private Step currentStep;

    public GoProgressReport(String threadName, long period) {
        this.period = period;
        this.timeUnit = TimeUnit.MILLISECONDS;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(run -> {
            Thread thread = new Thread(run, threadName);
            thread.setDaemon(true);
            return thread;
        });
    }

    public void start(Collection<GoFolder> folders) {
        this.totalFolders = folders.size();
        this.currentFolderIndex = 0L;
        this.itFolder = folders.iterator();
        this.totalFiles = folders.stream().map(f -> f.files().size()).reduce(0, Integer::sum).intValue();
        GoProgressReport.log("%d %s (%d %s) to be analyzed".formatted(this.totalFolders, GoProgressReport.pluralizeFolder(folders.size()), this.totalFiles, GoProgressReport.pluralizeFile(this.totalFiles)));
        this.nextFolder();
        this.scheduledTask = this.scheduler.scheduleAtFixedRate(() -> GoProgressReport.log("%d / %d %s analyzed, current folder: %s (%d %s%s)".formatted(this.currentFolderIndex, this.totalFolders, GoProgressReport.pluralizeFolder(this.currentFolderIndex), this.currentFolder.name(), this.currentFolder.files().size(), GoProgressReport.pluralizeFile(this.currentFolder.files().size()), GoProgressReport.formatStep(this.currentStep))), this.period, this.period, this.timeUnit);
    }

    private static String pluralizeFolder(long count) {
        return GoProgressReport.pluralizeWord("folder", count);
    }

    private static String pluralizeFile(long count) {
        return GoProgressReport.pluralizeWord("file", count);
    }

    private static String pluralizeWord(String word, long count) {
        if (count == 1L) {
            return word;
        }
        return word + "s";
    }

    private static String pluralizeHas(long count) {
        if (count == 1L) {
            return "has";
        }
        return "have";
    }

    private static String formatStep(@Nullable Step step) {
        if (step == null) {
            return "";
        }
        return ", %s".formatted(step.getDisplayName());
    }

    public void stop() {
        this.stopScheduler();
        GoProgressReport.log("%d/%d %s (%d %s) %s been analyzed".formatted(this.totalFolders, this.totalFolders, GoProgressReport.pluralizeFolder(this.totalFolders), this.totalFiles, GoProgressReport.pluralizeFile(this.totalFiles), GoProgressReport.pluralizeHas(this.totalFolders)));
    }

    public void cancel() {
        this.stopScheduler();
    }

    private void stopScheduler() {
        if (this.scheduledTask == null) {
            throw new IllegalStateException("Cannot stop: start method has to be called first");
        }
        this.scheduledTask.cancel(false);
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void nextFolder() {
        if (this.itFolder.hasNext()) {
            ++this.currentFolderIndex;
            this.currentFolder = this.itFolder.next();
            this.setStep(null);
        }
    }

    public synchronized void setStep(@Nullable Step step) {
        this.currentStep = step;
    }

    private static void log(String message) {
        LOG.info(message);
    }

    public static enum Step {
        CACHING,
        PARSING,
        HANDLING_PARSE_ERRORS,
        ANALYZING;


        public String getDisplayName() {
            return this.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        }
    }
}

