/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.go.plugin.InputFileContext;
import org.sonar.go.visitors.TreeVisitor;
import org.sonar.plugins.go.api.LiteralTree;
import org.sonar.plugins.go.api.StringLiteralTree;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.Tree;

public class SyntaxHighlighter
extends TreeVisitor<InputFileContext> {
    private NewHighlighting newHighlighting;

    public SyntaxHighlighter() {
        this.register(TopLevelTree.class, (ctx, tree) -> {
            tree.allComments().forEach(comment -> this.highlight((InputFileContext)ctx, comment.textRange(), TypeOfText.COMMENT));
            tree.metaData().tokens().stream().filter(t -> t.type() == Token.Type.KEYWORD).forEach(token -> this.highlight((InputFileContext)ctx, token.textRange(), TypeOfText.KEYWORD));
        });
        this.register(LiteralTree.class, (ctx, tree) -> this.highlight((InputFileContext)ctx, tree.metaData().textRange(), tree instanceof StringLiteralTree ? TypeOfText.STRING : TypeOfText.CONSTANT));
    }

    @Override
    protected void before(InputFileContext ctx, Tree root) {
        this.newHighlighting = ctx.sensorContext.newHighlighting().onFile(ctx.inputFile);
    }

    @Override
    protected void after(InputFileContext ctx, Tree root) {
        this.newHighlighting.save();
    }

    private void highlight(InputFileContext ctx, TextRange range, TypeOfText typeOfText) {
        org.sonar.api.batch.fs.TextRange textRange = ctx.textRange(range);
        if (textRange != null) {
            this.newHighlighting.highlight(textRange, typeOfText);
        }
    }
}

