/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import org.sonar.go.visitors.TreeContext;
import org.sonar.go.visitors.TreeVisitor;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.ClassDeclarationTree;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.ImportDeclarationTree;
import org.sonar.plugins.go.api.NativeTree;
import org.sonar.plugins.go.api.PackageDeclarationTree;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.Tree;

public class StatementsVisitor
extends TreeVisitor<TreeContext> {
    private int statements;

    public StatementsVisitor() {
        this.register(BlockTree.class, (ctx, tree) -> tree.statementOrExpressions().forEach(stmt -> {
            if (!StatementsVisitor.isDeclaration(stmt)) {
                ++this.statements;
            }
        }));
        this.register(TopLevelTree.class, (ctx, tree) -> tree.declarations().forEach(decl -> {
            if (!(StatementsVisitor.isDeclaration(decl) || StatementsVisitor.isNative(decl) || StatementsVisitor.isBlock(decl))) {
                ++this.statements;
            }
        }));
    }

    public int statements(Tree tree) {
        this.statements = 0;
        this.scan(new TreeContext(), tree);
        return this.statements;
    }

    @Override
    protected void before(TreeContext ctx, Tree root) {
        this.statements = 0;
    }

    private static boolean isDeclaration(Tree tree) {
        return tree instanceof ClassDeclarationTree || tree instanceof FunctionDeclarationTree || tree instanceof PackageDeclarationTree || tree instanceof ImportDeclarationTree;
    }

    private static boolean isNative(Tree tree) {
        return tree instanceof NativeTree;
    }

    private static boolean isBlock(Tree tree) {
        return tree instanceof BlockTree;
    }
}

