/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.go.plugin.ChecksVisitor;
import org.sonar.go.plugin.CpdVisitor;
import org.sonar.go.plugin.DurationStatistics;
import org.sonar.go.plugin.GoChecks;
import org.sonar.go.plugin.GoFolder;
import org.sonar.go.plugin.GoModFileAnalyzer;
import org.sonar.go.plugin.GoModFileDataStore;
import org.sonar.go.plugin.GoSensor;
import org.sonar.go.plugin.InputFileContext;
import org.sonar.go.plugin.IssueSuppressionVisitor;
import org.sonar.go.plugin.MemoryMonitor;
import org.sonar.go.plugin.MetricVisitor;
import org.sonar.go.plugin.PullRequestAwareVisitor;
import org.sonar.go.plugin.SkipNoSonarLinesVisitor;
import org.sonar.go.plugin.SyntaxHighlighter;
import org.sonar.go.plugin.caching.HashCacheUtils;
import org.sonar.go.plugin.converter.ASTConverterValidation;
import org.sonar.go.report.GoProgressReport;
import org.sonar.go.visitors.SymbolVisitor;
import org.sonar.go.visitors.TreeVisitor;
import org.sonar.plugins.go.api.ASTConverter;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.ClassDeclarationTree;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.ImportDeclarationTree;
import org.sonar.plugins.go.api.PackageDeclarationTree;
import org.sonar.plugins.go.api.ParseException;
import org.sonar.plugins.go.api.TextPointer;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeOrError;

public abstract class SlangSensor
implements Sensor {
    static final Predicate<Tree> EXECUTABLE_LINE_PREDICATE = t -> !(t instanceof PackageDeclarationTree) && !(t instanceof ImportDeclarationTree) && !(t instanceof ClassDeclarationTree) && !(t instanceof FunctionDeclarationTree) && !(t instanceof BlockTree);
    protected static final Pattern EMPTY_FILE_CONTENT_PATTERN = Pattern.compile("\\s*+");
    private static final Logger LOG = LoggerFactory.getLogger(SlangSensor.class);
    private static final int PROGRESS_REPORT_INTERVAL_SECOND = 10;
    private final NoSonarFilter noSonarFilter;
    private final Language language;
    private final FileLinesContextFactory fileLinesContextFactory;
    protected DurationStatistics durationStatistics;
    protected MemoryMonitor memoryMonitor;

    protected SlangSensor(NoSonarFilter noSonarFilter, FileLinesContextFactory fileLinesContextFactory, Language language) {
        this.noSonarFilter = noSonarFilter;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.language = language;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage(this.language.getKey()).name(this.language.getName() + " Sensor");
    }

    protected abstract ASTConverter astConverter();

    protected abstract GoChecks checks();

    protected abstract String repositoryKey();

    protected Predicate<Tree> executableLineOfCodePredicate() {
        return EXECUTABLE_LINE_PREDICATE;
    }

    protected void beforeAnalyzeFile(SensorContext sensorContext, List<GoFolder> inputFilesByFolder, GoModFileDataStore goModFileDataStore) {
    }

    protected boolean analyseFiles(ASTConverter converter, SensorContext sensorContext, List<InputFile> inputFiles, GoProgressReport goProgressReport, List<TreeVisitor<InputFileContext>> visitors, DurationStatistics statistics, GoModFileDataStore goModFileDataStore) {
        if (sensorContext.canSkipUnchangedFiles()) {
            LOG.info("The {} analyzer is running in a context where unchanged files can be skipped.", (Object)this.language);
        }
        List<GoFolder> filesByDirectory = SlangSensor.groupFilesByDirectory(inputFiles);
        goProgressReport.start(filesByDirectory);
        this.beforeAnalyzeFile(sensorContext, filesByDirectory, goModFileDataStore);
        for (GoFolder goFolder : filesByDirectory) {
            block5: {
                if (sensorContext.isCancelled()) {
                    return false;
                }
                List<InputFileContext> filesToAnalyse = goFolder.files().stream().map(inputFile -> new InputFileContext(sensorContext, (InputFile)inputFile)).toList();
                String moduleName = goModFileDataStore.retrieveClosestGoModFileData(goFolder.name()).moduleName();
                LOG.debug("Parse directory '{}', number of files: {}, nodule name: '{}'", new Object[]{goFolder.name(), filesToAnalyse.size(), moduleName});
                try {
                    SlangSensor.analyseDirectory(converter, filesToAnalyse, visitors, goProgressReport, statistics, sensorContext, moduleName);
                }
                catch (RuntimeException e) {
                    LOG.warn("Unable to parse directory '{}'.", (Object)goFolder.name(), (Object)e);
                    this.reportParseException(e, filesToAnalyse);
                    if (!GoSensor.isFailFast(sensorContext)) break block5;
                    throw e;
                }
            }
            goProgressReport.nextFolder();
        }
        return true;
    }

    private void reportParseException(RuntimeException e, List<InputFileContext> filesToAnalyse) {
        ParseException parseException;
        String inputFilePath;
        if (e instanceof ParseException && (inputFilePath = (parseException = (ParseException)e).getInputFilePath()) != null) {
            filesToAnalyse.stream().filter(inputFileContext -> inputFileContext.inputFile.toString().equals(inputFilePath)).findFirst().ifPresent(inputFileContext -> inputFileContext.reportAnalysisParseError(this.repositoryKey(), parseException.getMessage()));
        }
    }

    static List<GoFolder> groupFilesByDirectory(List<InputFile> inputFiles) {
        Map<String, List<InputFile>> filesByDirectory = inputFiles.stream().collect(Collectors.groupingBy(inputFile -> {
            String path = inputFile.uri().getPath();
            int lastSeparatorIndex = path.lastIndexOf("/");
            if (lastSeparatorIndex == -1) {
                return "";
            }
            return path.substring(0, lastSeparatorIndex);
        }));
        return filesByDirectory.entrySet().stream().map(entry -> new GoFolder((String)entry.getKey(), (List)entry.getValue())).toList();
    }

    static void analyseDirectory(ASTConverter converter, List<InputFileContext> inputFileContextList, List<TreeVisitor<InputFileContext>> visitors, GoProgressReport goProgressReport, DurationStatistics statistics, SensorContext sensorContext, String moduleName) {
        goProgressReport.setStep(GoProgressReport.Step.CACHING);
        Map<String, CacheEntry> filenameToCacheEntry = SlangSensor.filterOutFilesFromCache(inputFileContextList, visitors);
        Map<String, String> filenameToContentMap = filenameToCacheEntry.values().stream().map(SlangSensor::convertCacheEntryToFilenameAndContent).filter(entry -> !EMPTY_FILE_CONTENT_PATTERN.matcher((CharSequence)entry.getValue()).matches()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (filenameToContentMap.isEmpty()) {
            return;
        }
        goProgressReport.setStep(GoProgressReport.Step.PARSING);
        Map treeOrErrorMap = statistics.time("Parse", () -> converter.parse(filenameToContentMap, moduleName));
        goProgressReport.setStep(GoProgressReport.Step.HANDLING_PARSE_ERRORS);
        SlangSensor.handleParsingErrors(sensorContext, treeOrErrorMap, filenameToCacheEntry);
        goProgressReport.setStep(GoProgressReport.Step.ANALYZING);
        SlangSensor.visitTrees(visitors, statistics, treeOrErrorMap, filenameToCacheEntry);
    }

    private static Map.Entry<String, String> convertCacheEntryToFilenameAndContent(CacheEntry cacheEntry) {
        try {
            String content = cacheEntry.fileContext().inputFile.contents();
            String fileName = cacheEntry.fileContext().inputFile.toString();
            return Map.entry(fileName, content);
        }
        catch (IOException | RuntimeException e) {
            throw SlangSensor.toParseException("read", cacheEntry.fileContext().inputFile, e);
        }
    }

    private static void handleParsingErrors(SensorContext sensorContext, Map<String, TreeOrError> treeOrErrorMap, Map<String, CacheEntry> filenameToCacheResult) {
        boolean isAnyError = false;
        for (Map.Entry<String, TreeOrError> filenameToTree : treeOrErrorMap.entrySet()) {
            TreeOrError treeOrError = filenameToTree.getValue();
            if (!treeOrError.isError()) continue;
            isAnyError = true;
            String fileName = filenameToTree.getKey();
            LOG.warn("Unable to parse file: {}. {}", (Object)fileName, (Object)treeOrError.error());
            filenameToCacheResult.get(fileName).fileContext().reportAnalysisParseError("go", treeOrError.error());
        }
        if (isAnyError && GoSensor.isFailFast(sensorContext)) {
            throw new IllegalStateException("Exception when analyzing files. See logs above for details.");
        }
    }

    private static Map<String, CacheEntry> filterOutFilesFromCache(List<InputFileContext> inputFileContexts, List<TreeVisitor<InputFileContext>> visitors) {
        HashMap<String, CacheEntry> result = new HashMap<String, CacheEntry>();
        for (InputFileContext inputFileContext : inputFileContexts) {
            if (SlangSensor.fileCanBeSkipped(inputFileContext)) {
                String fileKey = inputFileContext.inputFile.key();
                LOG.debug("Checking that previous results can be reused for input file {}.", (Object)fileKey);
                Map<PullRequestAwareVisitor, Boolean> successfulCacheReuseByVisitor = visitors.stream().filter(PullRequestAwareVisitor.class::isInstance).map(PullRequestAwareVisitor.class::cast).collect(Collectors.toMap(visitor -> visitor, visitor -> SlangSensor.reusePreviousResults(visitor, inputFileContext)));
                boolean allVisitorsSuccessful = successfulCacheReuseByVisitor.values().stream().allMatch(Boolean.TRUE::equals);
                if (allVisitorsSuccessful) {
                    LOG.debug("Skipping input file {} (status is unchanged).", (Object)fileKey);
                    HashCacheUtils.copyFromPrevious(inputFileContext);
                    continue;
                }
                LOG.debug("Will convert input file {} for full analysis.", (Object)fileKey);
                List<TreeVisitor<InputFileContext>> visitorsToSkip = successfulCacheReuseByVisitor.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(visitor -> visitor).toList();
                result.put(inputFileContext.inputFile.toString(), new CacheEntry(inputFileContext, visitorsToSkip));
                continue;
            }
            result.put(inputFileContext.inputFile.toString(), new CacheEntry(inputFileContext, List.of()));
        }
        return result;
    }

    private static void visitTrees(List<TreeVisitor<InputFileContext>> visitors, DurationStatistics statistics, Map<String, TreeOrError> treeOrErrorMap, Map<String, CacheEntry> filenameToCacheEntry) {
        for (Map.Entry<String, TreeOrError> filenameToTree : treeOrErrorMap.entrySet()) {
            TreeOrError treeOrError = filenameToTree.getValue();
            if (!treeOrError.isTree()) continue;
            String filename = filenameToTree.getKey();
            CacheEntry cacheResult = filenameToCacheEntry.get(filename);
            SlangSensor.visitTree(visitors, statistics, cacheResult, treeOrError.tree());
        }
    }

    private static void visitTree(List<TreeVisitor<InputFileContext>> visitors, DurationStatistics statistics, CacheEntry cacheResult, Tree tree) {
        List<TreeVisitor<InputFileContext>> visitorsToSkip = cacheResult.visitorsToSkip();
        InputFileContext inputFileContext = cacheResult.fileContext();
        for (TreeVisitor<InputFileContext> visitor : visitors) {
            try {
                if (visitorsToSkip.contains(visitor)) continue;
                String visitorId = visitor.getClass().getSimpleName();
                statistics.time(visitorId, () -> visitor.scan(inputFileContext, tree));
            }
            catch (RuntimeException e) {
                inputFileContext.reportAnalysisError(e.getMessage(), null);
                String message = "Cannot analyse '" + String.valueOf(inputFileContext.inputFile) + "': " + e.getMessage();
                LOG.warn(message, (Throwable)e);
            }
        }
        SlangSensor.writeHashToCache(inputFileContext);
    }

    private static boolean fileCanBeSkipped(InputFileContext inputFileContext) {
        SensorContext sensorContext = inputFileContext.sensorContext;
        if (!sensorContext.canSkipUnchangedFiles()) {
            return false;
        }
        return HashCacheUtils.hasSameHashCached(inputFileContext);
    }

    private static void writeHashToCache(InputFileContext inputFileContext) {
        HashCacheUtils.writeHashForNextAnalysis(inputFileContext);
    }

    private static boolean reusePreviousResults(PullRequestAwareVisitor visitor, InputFileContext inputFileContext) {
        boolean success = visitor.reusePreviousResults(inputFileContext);
        if (success) {
            return true;
        }
        String message = String.format("Visitor %s failed to reuse previous results for input file %s.", visitor.getClass().getSimpleName(), inputFileContext.inputFile.key());
        LOG.debug(message);
        return false;
    }

    protected static ParseException toParseException(String action, InputFile inputFile, Exception cause) {
        TextPointer textPointer;
        if (cause instanceof ParseException) {
            ParseException actual = (ParseException)cause;
            textPointer = actual.getPosition();
        } else {
            textPointer = null;
        }
        TextPointer position = textPointer;
        return new ParseException("Cannot " + action + " '" + String.valueOf(inputFile) + "': " + cause.getMessage(), position, cause, inputFile.toString());
    }

    public void execute(SensorContext sensorContext) {
        try {
            if (!this.astConverter().isInitialized() && sensorContext.runtime().getProduct() == SonarProduct.SONARLINT) {
                LOG.info("Skipping the Go analysis, parsing is not possible with uninitialized Go converter.");
                return;
            }
            this.executeLogic(sensorContext);
        }
        catch (RuntimeException e) {
            if (GoSensor.isFailFast(sensorContext)) {
                throw e;
            }
            LOG.error("An error occurred during the analysis of the Go language:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLogic(SensorContext sensorContext) {
        this.initialize(sensorContext);
        FileSystem fileSystem = sensorContext.fileSystem();
        FilePredicate mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasLanguage(this.language.getKey()), fileSystem.predicates().hasType(InputFile.Type.MAIN));
        List<InputFile> inputFiles = StreamSupport.stream(fileSystem.inputFiles(mainFilePredicate).spliterator(), false).toList();
        GoProgressReport goProgressReport = new GoProgressReport("Progress of the " + this.language.getName() + " analysis", TimeUnit.SECONDS.toMillis(10L));
        boolean success = false;
        ASTConverter converter = ASTConverterValidation.wrap(this.astConverter(), sensorContext.config());
        GoModFileDataStore goModFileDataStore = new GoModFileAnalyzer(sensorContext).analyzeGoModFiles();
        try {
            List<TreeVisitor<InputFileContext>> visitors = this.visitors(sensorContext, this.durationStatistics, goModFileDataStore);
            success = this.analyseFiles(converter, sensorContext, inputFiles, goProgressReport, visitors, this.durationStatistics, goModFileDataStore);
        }
        finally {
            if (success) {
                goProgressReport.stop();
            } else {
                goProgressReport.cancel();
            }
            converter.terminate();
        }
        this.processMetrics();
        this.cleanUp();
    }

    protected void initialize(SensorContext sensorContext) {
        this.durationStatistics = new DurationStatistics(sensorContext.config());
        this.memoryMonitor = new MemoryMonitor(sensorContext.config());
    }

    protected void processMetrics() {
        this.durationStatistics.log();
        this.memoryMonitor.addRecord("End of the sensor");
        this.memoryMonitor.logMemory();
    }

    protected void cleanUp() {
        this.durationStatistics = null;
        this.memoryMonitor = null;
    }

    private List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics, GoModFileDataStore goModFileDataStore) {
        if (sensorContext.runtime().getProduct() == SonarProduct.SONARLINT) {
            return Arrays.asList(new IssueSuppressionVisitor(), new SkipNoSonarLinesVisitor(this.noSonarFilter), new SymbolVisitor(), new ChecksVisitor(this.checks(), statistics, goModFileDataStore));
        }
        return Arrays.asList(new IssueSuppressionVisitor(), new MetricVisitor(this.fileLinesContextFactory, this.executableLineOfCodePredicate()), new SkipNoSonarLinesVisitor(this.noSonarFilter), new SymbolVisitor(), new ChecksVisitor(this.checks(), statistics, goModFileDataStore), new CpdVisitor(), new SyntaxHighlighter());
    }

    record CacheEntry(InputFileContext fileContext, List<TreeVisitor<InputFileContext>> visitorsToSkip) {
    }
}

