/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.go.impl.TextPointerImpl;
import org.sonar.go.plugin.GoSensor;
import org.sonar.go.visitors.TreeContext;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

public class InputFileContext
extends TreeContext {
    private static final Logger LOG = LoggerFactory.getLogger(InputFileContext.class);
    private static final String PARSING_ERROR_RULE_KEY = "S2260";
    private static final int MIN_NUMBER_OF_PARTS_FOR_LOCATION_EXTRACT = 3;
    private static final int LINE_INDEX = 1;
    private static final int LINE_OFFSET_INDEX = 2;
    private Map<String, Set<TextRange>> filteredRules = new HashMap<String, Set<TextRange>>();
    public final SensorContext sensorContext;
    public final InputFile inputFile;

    public InputFileContext(SensorContext sensorContext, InputFile inputFile) {
        this.sensorContext = sensorContext;
        this.inputFile = inputFile;
    }

    @CheckForNull
    public org.sonar.api.batch.fs.TextRange textRange(@Nullable TextRange textRange) {
        if (textRange == null) {
            return null;
        }
        try {
            return this.inputFile.newRange(textRange.start().line(), textRange.start().lineOffset(), textRange.end().line(), textRange.end().lineOffset());
        }
        catch (IllegalArgumentException e) {
            int numberOfLines = this.inputFile.lines();
            String message = "Invalid %s, for file: %s, number of lines: %s".formatted(textRange, this.inputFile, numberOfLines);
            LOG.debug(message, (Throwable)e);
            if (GoSensor.isFailFast(this.sensorContext)) {
                throw new IllegalStateException(message, e);
            }
            return null;
        }
    }

    public void reportIssue(RuleKey ruleKey, @Nullable TextRange textRange, String message, List<SecondaryLocation> secondaryLocations, @Nullable Double gap) {
        if (textRange != null) {
            if (this.filteredRules.getOrDefault(ruleKey.toString(), Collections.emptySet()).stream().anyMatch(textRange::isInside)) {
                return;
            }
        }
        NewIssue issue = this.sensorContext.newIssue();
        NewIssueLocation issueLocation = issue.newLocation().on((InputComponent)this.inputFile).message(message);
        org.sonar.api.batch.fs.TextRange location = this.textRange(textRange);
        if (location != null) {
            issueLocation.at(location);
        }
        issue.forRule(ruleKey).at(issueLocation).gap(gap);
        secondaryLocations.forEach(secondary -> {
            NewIssueLocation newIssueLocation = issue.newLocation().on((InputComponent)this.inputFile).message(secondary.message == null ? "" : secondary.message);
            org.sonar.api.batch.fs.TextRange secondaryLocation = this.textRange(secondary.textRange);
            if (secondaryLocation != null) {
                newIssueLocation.at(secondaryLocation);
            }
            issue.addLocation(newIssueLocation);
        });
        issue.save();
    }

    public void reportAnalysisParseError(String repositoryKey, String errorMessage) {
        org.sonar.plugins.go.api.TextPointer location = InputFileContext.extractLocation(errorMessage);
        this.reportAnalysisError("Unable to parse file: " + String.valueOf(this.inputFile), location);
        RuleKey parsingErrorRuleKey = RuleKey.of((String)repositoryKey, (String)PARSING_ERROR_RULE_KEY);
        if (this.sensorContext.activeRules().find(parsingErrorRuleKey) == null) {
            return;
        }
        NewIssue parseError = this.sensorContext.newIssue();
        NewIssueLocation parseErrorLocation = parseError.newLocation().on((InputComponent)this.inputFile).message("A parsing error occurred in this file.");
        Optional.of(location).map(org.sonar.plugins.go.api.TextPointer::line).flatMap(l -> InputFileContext.safeExtractSelectLine(this.inputFile, l)).ifPresent(arg_0 -> ((NewIssueLocation)parseErrorLocation).at(arg_0));
        parseError.forRule(parsingErrorRuleKey).at(parseErrorLocation).save();
    }

    private static org.sonar.plugins.go.api.TextPointer extractLocation(String errorMessage) {
        String[] parts = errorMessage.split(":");
        if (parts.length < 3) {
            return new TextPointerImpl(1, 0);
        }
        try {
            int line = Integer.parseInt(parts[1]);
            int lineOffset = Integer.parseInt(parts[2]);
            return new TextPointerImpl(line, lineOffset);
        }
        catch (NumberFormatException e) {
            return new TextPointerImpl(1, 0);
        }
    }

    public void reportAnalysisError(String message, @Nullable org.sonar.plugins.go.api.TextPointer location) {
        NewAnalysisError error = this.sensorContext.newAnalysisError();
        error.message(message).onFile(this.inputFile);
        if (location != null) {
            try {
                TextPointer pointerLocation = this.inputFile.newPointer(location.line(), location.lineOffset());
                error.at(pointerLocation);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Invalid location '{}' for file {} when reporting parsing error.", new Object[]{location, this.inputFile, e});
            }
        }
        error.save();
    }

    static Optional<org.sonar.api.batch.fs.TextRange> safeExtractSelectLine(InputFile inputFile, int line) {
        try {
            return Optional.of(inputFile.selectLine(line));
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Invalid line '{}' for file {} when reporting parsing error.", new Object[]{line, inputFile, e});
            return Optional.empty();
        }
    }

    public void setFilteredRules(Map<String, Set<TextRange>> filteredRules) {
        this.filteredRules = filteredRules;
    }
}

