/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.util.function.Predicate;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.go.checks.GoCheckList;
import org.sonar.go.converter.GoConverter;
import org.sonar.go.plugin.GoChecks;
import org.sonar.go.plugin.GoLanguage;
import org.sonar.go.plugin.SlangSensor;
import org.sonar.go.utils.NativeKinds;
import org.sonar.plugins.go.api.ASTConverter;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.VariableDeclarationTree;

public class GoSensor
extends SlangSensor {
    public static final String FAIL_FAST_PROPERTY_NAME = "sonar.internal.analysis.failFast";
    public static final String DEBUG_TYPE_CHECK_PROPERTY_NAME = "sonar.go.internal.debugTypeCheck";
    private final GoChecks checks;
    private final ASTConverter goConverter;

    public GoSensor(CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, GoLanguage language, GoConverter goConverter) {
        this(GoSensor.initializeChecks(checkFactory), fileLinesContextFactory, noSonarFilter, language, goConverter);
    }

    public GoSensor(GoChecks checks, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, GoLanguage language, GoConverter goConverter) {
        super(noSonarFilter, fileLinesContextFactory, (Language)language);
        this.checks = checks;
        this.goConverter = goConverter;
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("go").name("Code Quality and Security for Go");
    }

    @Override
    protected ASTConverter astConverter() {
        return this.goConverter;
    }

    private static GoChecks initializeChecks(CheckFactory checkFactory) {
        return new GoChecks(checkFactory).addChecks("go", GoCheckList.checks());
    }

    @Override
    public GoChecks checks() {
        return this.checks;
    }

    @Override
    protected String repositoryKey() {
        return "go";
    }

    @Override
    protected Predicate<Tree> executableLineOfCodePredicate() {
        return super.executableLineOfCodePredicate().and(t -> !(t instanceof VariableDeclarationTree) && !GoSensor.isGenericDeclaration(t));
    }

    @Override
    protected void initialize(SensorContext sensorContext) {
        super.initialize(sensorContext);
        if (GoSensor.debugTypeCheck(sensorContext)) {
            this.astConverter().debugTypeCheck();
        }
    }

    private static boolean isGenericDeclaration(Tree tree) {
        return NativeKinds.isStringNativeKind(tree, str -> str.contains("GenDecl"));
    }

    public static boolean isFailFast(SensorContext context) {
        return context.config().getBoolean(FAIL_FAST_PROPERTY_NAME).orElse(false);
    }

    public static boolean debugTypeCheck(SensorContext context) {
        return context.config().getBoolean(DEBUG_TYPE_CHECK_PROPERTY_NAME).orElse(false);
    }
}

