/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.plugins.go.api.checks.GoModFileData;

public class GoModFileDataStore {
    private Node root = new Node();
    private String rootPath = "";

    String getRootPath() {
        return this.rootPath;
    }

    public void addGoModFile(URI uriGoMod, GoModFileData goModFileData) {
        String[] folders = GoModFileDataStore.splitPathIntoFolderName(uriGoMod.resolve(".").getPath());
        Node currentNode = this.root;
        for (String folder : folders) {
            currentNode = currentNode.children.computeIfAbsent(folder, k -> new Node());
        }
        currentNode.goModFileData = goModFileData;
    }

    public void complete() {
        StringBuilder sb = new StringBuilder();
        while (this.root.children.size() == 1 && this.root.goModFileData == GoModFileData.UNKNOWN_DATA) {
            Map.Entry<String, Node> entry = this.root.children.entrySet().iterator().next();
            sb.append("/").append(entry.getKey());
            this.root = entry.getValue();
        }
        this.rootPath = sb.toString();
    }

    public GoModFileData retrieveClosestGoModFileData(String path) {
        if (!path.startsWith(this.rootPath)) {
            return GoModFileData.UNKNOWN_DATA;
        }
        path = path.substring(this.rootPath.length());
        GoModFileData currentGoModFileData = this.root.goModFileData;
        String[] folders = GoModFileDataStore.splitPathIntoFolderName(path);
        Node currentNode = this.root;
        for (String folder : folders) {
            currentNode = currentNode.children.get(folder);
            if (currentNode == null) {
                return currentGoModFileData;
            }
            if (currentNode.goModFileData == GoModFileData.UNKNOWN_DATA) continue;
            currentGoModFileData = currentNode.goModFileData;
        }
        return currentGoModFileData;
    }

    public GoModFileData retrieveClosestGoModFileData(URI uri) {
        return this.retrieveClosestGoModFileData(uri.getPath());
    }

    private static String[] splitPathIntoFolderName(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path.split("/");
    }

    private static class Node {
        @Nullable
        private GoModFileData goModFileData = GoModFileData.UNKNOWN_DATA;
        private final Map<String, Node> children = new HashMap<String, Node>();
    }
}

