/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.go.plugin.GoModFileDataStore;
import org.sonar.go.plugin.GoModFileFinder;
import org.sonar.plugins.go.api.checks.GoModFileData;
import org.sonar.plugins.go.api.checks.GoVersion;

public class GoModFileAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(GoModFileAnalyzer.class);
    private static final Pattern LINE_TERMINATOR = Pattern.compile("[\\n\\r\\u2028\\u2029]");
    private static final String STRING_OR_IDENTIFIER_PATTERN_STRING = "\"(?:\\\\.|[^\"\\\\])*+\"|[^\\s]++";
    private static final String REPLACE_SPEC = "\\s*+(?<moduleLeft>\"(?:\\\\.|[^\"\\\\])*+\"|[^\\s]++)(?:\\s++(?<versionLeft>[^\\s]++))?\\s*+=>\\s*+(?<moduleRight>\"(?:\\\\.|[^\"\\\\])*+\"|[^\\s]++)(?:\\s++(?<versionRight>[^\\s]++))?\\s*+$";
    private static final Pattern MODULE_PATTERN = Pattern.compile("^module\\s++(?<moduleName>\"(?:\\\\.|[^\"\\\\])*+\"|[^\\s]++)\\s*+$");
    private static final Pattern VERSION_PATTERN = Pattern.compile("^go\\s++(?<majorAndMinor>[1-9]\\d*+\\.\\d++)(?<patch>\\.\\d++)?(?:(?:rc|beta)\\d+)?\\s*+$");
    private static final Pattern SIMPLE_REPLACE_PATTERN = Pattern.compile("^replace\\s++\\s*+(?<moduleLeft>\"(?:\\\\.|[^\"\\\\])*+\"|[^\\s]++)(?:\\s++(?<versionLeft>[^\\s]++))?\\s*+=>\\s*+(?<moduleRight>\"(?:\\\\.|[^\"\\\\])*+\"|[^\\s]++)(?:\\s++(?<versionRight>[^\\s]++))?\\s*+$$");
    private static final Pattern MULTIPLE_REPLACE_PATTERN = Pattern.compile("^replace\\s++\\(\\s*+$");
    private static final Pattern REPLACE_SPEC_PATTERN = Pattern.compile("\\s*+(?<moduleLeft>\"(?:\\\\.|[^\"\\\\])*+\"|[^\\s]++)(?:\\s++(?<versionLeft>[^\\s]++))?\\s*+=>\\s*+(?<moduleRight>\"(?:\\\\.|[^\"\\\\])*+\"|[^\\s]++)(?:\\s++(?<versionRight>[^\\s]++))?\\s*+$");
    private final SensorContext sensorContext;

    public GoModFileAnalyzer(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
    }

    public GoModFileDataStore analyzeGoModFiles() {
        if (this.sensorContext.runtime().getProduct() == SonarProduct.SONARLINT) {
            return new GoModFileDataStore();
        }
        List<InputFile> modFiles = GoModFileFinder.findGoModFiles(this.sensorContext);
        if (modFiles.isEmpty()) {
            LOG.debug("Expected at least one go.mod file, but found none.");
            return new GoModFileDataStore();
        }
        GoModFileDataStore goModFileDataStore = new GoModFileDataStore();
        for (InputFile goModFile : modFiles) {
            try {
                GoModFileData goModFileData = GoModFileAnalyzer.analyzeGoModFileContent(goModFile.contents(), goModFile.toString());
                goModFileDataStore.addGoModFile(goModFile.uri(), goModFileData);
            }
            catch (IOException e) {
                LOG.debug("Failed to read go.mod file: {}", (Object)goModFile, (Object)e);
            }
        }
        goModFileDataStore.complete();
        return goModFileDataStore;
    }

    public static GoModFileData analyzeGoModFileContent(String content, String loggableFilePath) {
        String[] lines = LINE_TERMINATOR.split(content);
        String moduleName = "";
        GoVersion goVersion = GoVersion.UNKNOWN_VERSION;
        ArrayList<Map.Entry<GoModFileData.ModuleSpec, GoModFileData.ModuleSpec>> replacedModules = new ArrayList<Map.Entry<GoModFileData.ModuleSpec, GoModFileData.ModuleSpec>>();
        Iterator<String> lineIterator = Arrays.stream(lines).iterator();
        while (lineIterator.hasNext()) {
            Optional<String> optModuleName;
            Optional<GoVersion> optVersion;
            String line = (String)lineIterator.next();
            if (goVersion == GoVersion.UNKNOWN_VERSION && (optVersion = GoModFileAnalyzer.parseVersion(line)).isPresent()) {
                goVersion = optVersion.get();
            }
            if ((optModuleName = GoModFileAnalyzer.parseModuleName(line)).isPresent() && moduleName.isEmpty()) {
                moduleName = optModuleName.get();
            }
            replacedModules.addAll(GoModFileAnalyzer.parseReplacedModules(line, lineIterator));
        }
        GoModFileAnalyzer.logDetails(goVersion, moduleName, loggableFilePath);
        return new GoModFileData(moduleName, goVersion, replacedModules, loggableFilePath);
    }

    private static void logDetails(GoVersion goVersion, String moduleName, String loggableFilePath) {
        if (goVersion == GoVersion.UNKNOWN_VERSION) {
            LOG.debug("Failed to detect a go version in the go.mod file: {}", (Object)loggableFilePath);
        } else {
            LOG.debug("Detected go version in project from {}: {}", (Object)loggableFilePath, (Object)goVersion);
        }
        if (moduleName.isEmpty()) {
            LOG.debug("Failed to detect a module name in the go.mod file: {}", (Object)loggableFilePath);
        } else {
            LOG.debug("Detected go module name in project from {}: {}", (Object)loggableFilePath, (Object)moduleName);
        }
    }

    private static Optional<String> parseModuleName(String line) {
        Matcher matcher = MODULE_PATTERN.matcher(line);
        if (matcher.find()) {
            String moduleName = matcher.group("moduleName");
            return Optional.of(GoModFileAnalyzer.removeQuotes(moduleName));
        }
        return Optional.empty();
    }

    private static Optional<GoVersion> parseVersion(String line) {
        Matcher matcher = VERSION_PATTERN.matcher(line);
        if (matcher.find()) {
            String versionToParse = matcher.group("majorAndMinor");
            String patch = matcher.group("patch");
            if (patch != null) {
                versionToParse = versionToParse.concat(patch);
            }
            GoVersion version = GoVersion.parse(versionToParse);
            return Optional.of(version);
        }
        return Optional.empty();
    }

    private static List<Map.Entry<GoModFileData.ModuleSpec, GoModFileData.ModuleSpec>> parseReplacedModules(String line, Iterator<String> lineIterator) {
        Matcher matcherSimpleReplace = SIMPLE_REPLACE_PATTERN.matcher(line);
        if (matcherSimpleReplace.find()) {
            return List.of(GoModFileAnalyzer.processReplaceSpec(matcherSimpleReplace));
        }
        Matcher matcherMultiReplace = MULTIPLE_REPLACE_PATTERN.matcher(line);
        if (matcherMultiReplace.find()) {
            return GoModFileAnalyzer.processMultiReplaceModule(lineIterator);
        }
        return Collections.emptyList();
    }

    private static List<Map.Entry<GoModFileData.ModuleSpec, GoModFileData.ModuleSpec>> processMultiReplaceModule(Iterator<String> lineIterator) {
        String line;
        ArrayList<Map.Entry<GoModFileData.ModuleSpec, GoModFileData.ModuleSpec>> result = new ArrayList<Map.Entry<GoModFileData.ModuleSpec, GoModFileData.ModuleSpec>>();
        while (lineIterator.hasNext() && !")".equals((line = lineIterator.next()).trim())) {
            Matcher matcher = REPLACE_SPEC_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            result.add(GoModFileAnalyzer.processReplaceSpec(matcher));
        }
        return result;
    }

    private static Map.Entry<GoModFileData.ModuleSpec, GoModFileData.ModuleSpec> processReplaceSpec(Matcher matcher) {
        String moduleLeft = GoModFileAnalyzer.removeQuotes(matcher.group("moduleLeft"));
        String versionLeft = matcher.group("versionLeft");
        String moduleRight = GoModFileAnalyzer.removeQuotes(matcher.group("moduleRight"));
        String versionRight = matcher.group("versionRight");
        GoModFileData.ModuleSpec moduleSpecLeft = new GoModFileData.ModuleSpec(moduleLeft, versionLeft);
        GoModFileData.ModuleSpec moduleSpecRight = new GoModFileData.ModuleSpec(moduleRight, versionRight);
        return Map.entry(moduleSpecLeft, moduleSpecRight);
    }

    private static String removeQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

