/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.go.impl.TextRangeImpl;
import org.sonar.go.impl.TokenImpl;
import org.sonar.go.plugin.InputFileContext;
import org.sonar.go.plugin.PullRequestAwareVisitor;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.TopLevelTree;

public class CpdVisitor
extends PullRequestAwareVisitor {
    static final char ASCII_UNIT_SEPARATOR = '\u001f';
    static final char ASCII_RECORD_SEPARATOR = '\u001e';
    private static final Logger LOG = LoggerFactory.getLogger((String)CpdVisitor.class.getName());

    public CpdVisitor() {
        this.register(TopLevelTree.class, (ctx, tree) -> {
            NewCpdTokens cpdTokens = ctx.sensorContext.newCpdTokens().onFile(ctx.inputFile);
            List<Token> tokens = tree.metaData().tokens();
            ArrayList<Token> tokensToCache = new ArrayList<Token>(tokens.size());
            boolean foundFirstToken = tree.firstCpdToken() == null;
            for (Token token : tokens) {
                if (!(foundFirstToken = foundFirstToken || token == tree.firstCpdToken())) continue;
                String text = CpdVisitor.substituteText(token);
                TextRange textRange = token.textRange();
                org.sonar.api.batch.fs.TextRange range = ctx.textRange(textRange);
                if (range != null) {
                    cpdTokens.addToken(range, text);
                }
                if (!ctx.sensorContext.isCacheEnabled()) continue;
                tokensToCache.add(token);
            }
            cpdTokens.save();
            CpdVisitor.cacheNewTokens(ctx, tokensToCache);
        });
    }

    @Override
    public boolean reusePreviousResults(InputFileContext ctx) {
        if (this.canReusePreviousResults(ctx)) {
            NewCpdTokens reusedTokens = ctx.sensorContext.newCpdTokens().onFile(ctx.inputFile);
            String fileKey = ctx.inputFile.key();
            LOG.debug("Looking up cached CPD tokens for {} ...", (Object)fileKey);
            ReadCache cache = ctx.sensorContext.previousCache();
            String key = CpdVisitor.computeCacheKey(ctx.inputFile);
            if (cache.contains(key)) {
                LOG.debug("Found cached CPD tokens for {}.", (Object)fileKey);
                LOG.debug("Loading cached CPD tokens for {} ...", (Object)fileKey);
                List<Token> tokens = null;
                try (InputStream in = cache.read(key);){
                    tokens = CpdVisitor.deserialize(in.readAllBytes());
                }
                catch (IOException | IllegalArgumentException e) {
                    LOG.warn("Failed to load cached CPD tokens for input file %s.".formatted(fileKey));
                    return false;
                }
                CpdVisitor.loadCachedTokens(ctx, fileKey, tokens, reusedTokens);
                try {
                    ctx.sensorContext.nextCache().copyFromPrevious(key);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Failed to copy previous cached results for input file %s.".formatted(fileKey));
                    return false;
                }
                reusedTokens.save();
                return true;
            }
        }
        return false;
    }

    private static void loadCachedTokens(InputFileContext ctx, String fileKey, List<Token> tokens, NewCpdTokens reusedTokens) {
        LOG.debug("Loaded cached CPD tokens for {}.", (Object)fileKey);
        for (Token token : tokens) {
            String text = CpdVisitor.substituteText(token);
            org.sonar.api.batch.fs.TextRange range = ctx.textRange(token.textRange());
            if (range == null) continue;
            reusedTokens.addToken(range, text);
        }
    }

    private static void cacheNewTokens(InputFileContext ctx, List<Token> tokens) {
        if (ctx.sensorContext.isCacheEnabled()) {
            try {
                ctx.sensorContext.nextCache().write(CpdVisitor.computeCacheKey(ctx.inputFile), CpdVisitor.serialize(tokens));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Failed to write CPD tokens to cache for input file {}: {}", (Object)ctx.inputFile.key(), (Object)e.getMessage());
            }
        }
    }

    static String computeCacheKey(InputFile inputFile) {
        return "slang:cpd-tokens:%s".formatted(inputFile.key());
    }

    static byte[] serialize(List<Token> tokens) {
        return tokens.stream().map(CpdVisitor::serialize).collect(Collectors.joining(String.valueOf('\u001e'))).getBytes(StandardCharsets.UTF_8);
    }

    private static String serialize(Token token) {
        TextRange textRange = token.textRange();
        return String.format("%d,%d,%d,%d%c%s%c%s", new Object[]{textRange.start().line(), textRange.start().lineOffset(), textRange.end().line(), textRange.end().lineOffset(), Character.valueOf('\u001f'), token.text(), Character.valueOf('\u001f'), token.type()});
    }

    static List<Token> deserialize(byte[] serialized) {
        if (serialized.length == 0) {
            return Collections.emptyList();
        }
        String str = new String(serialized, StandardCharsets.UTF_8);
        String[] tokensAsStrings = str.split(String.valueOf('\u001e'));
        try {
            return Arrays.stream(tokensAsStrings).map(CpdVisitor::deserialize).toList();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NoSuchElementException e) {
            throw new IllegalArgumentException("Could not deserialize cached CPD tokens: %s".formatted(e.getMessage()), e);
        }
    }

    private static Token deserialize(String tokenAsString) {
        String[] fields = tokenAsString.split(String.valueOf('\u001f'));
        List<Integer> rangeIndices = Arrays.stream(fields[0].split(",")).map(Integer::valueOf).toList();
        TextRangeImpl textRange = new TextRangeImpl(rangeIndices.get(0), rangeIndices.get(1), rangeIndices.get(2), rangeIndices.get(3));
        String text = fields[1];
        Token.Type type = Token.Type.valueOf(fields[2]);
        return new TokenImpl(textRange, text, type);
    }

    private static String substituteText(Token token) {
        return token.type() == Token.Type.STRING_LITERAL ? "LITERAL" : token.text();
    }
}

