/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.sonar.plugins.go.api.Comment;
import org.sonar.plugins.go.api.TextRange;

public class CommentAnalysisUtils {
    public static final String NOSONAR_PREFIX = "NOSONAR";
    private static final boolean[] IS_NON_BLANK_CHAR_IN_COMMENTS = new boolean[127];

    private CommentAnalysisUtils() {
    }

    static boolean isNosonarComment(Comment comment) {
        return comment.contentText().trim().toUpperCase(Locale.ENGLISH).startsWith(NOSONAR_PREFIX);
    }

    static Set<Integer> findNonEmptyCommentLines(TextRange range, String content) {
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        int startLine = range.start().line();
        if (startLine == range.end().line()) {
            if (CommentAnalysisUtils.isNotBlank(content)) {
                lineNumbers.add(startLine);
            }
        } else {
            String[] lines = content.split("\r\n|\n|\r", -1);
            for (int i = 0; i < lines.length; ++i) {
                if (!CommentAnalysisUtils.isNotBlank(lines[i])) continue;
                lineNumbers.add(startLine + i);
            }
        }
        return lineNumbers;
    }

    private static boolean isNotBlank(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (ch < IS_NON_BLANK_CHAR_IN_COMMENTS.length && !IS_NON_BLANK_CHAR_IN_COMMENTS[ch]) continue;
            return true;
        }
        return false;
    }

    static {
        for (int c = 0; c < IS_NON_BLANK_CHAR_IN_COMMENTS.length; ++c) {
            CommentAnalysisUtils.IS_NON_BLANK_CHAR_IN_COMMENTS[c] = c > 32 && "*#-=|".indexOf(c) == -1;
        }
    }
}

