/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.io.IOException;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.rule.RuleKey;
import org.sonar.go.plugin.DurationStatistics;
import org.sonar.go.plugin.GoChecks;
import org.sonar.go.plugin.GoModFileDataStore;
import org.sonar.go.plugin.InputFileContext;
import org.sonar.go.visitors.TreeVisitor;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.GoModFileData;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

public class ChecksVisitor
extends TreeVisitor<InputFileContext> {
    private final DurationStatistics statistics;
    private final GoModFileDataStore goModFileDataStore;

    public ChecksVisitor(GoChecks goChecks, DurationStatistics statistics, GoModFileDataStore goModFileDataStore) {
        this.statistics = statistics;
        this.goModFileDataStore = goModFileDataStore;
        List<GoCheck> rulesActiveInSonarQube = goChecks.all();
        for (GoCheck check : rulesActiveInSonarQube) {
            RuleKey ruleKey = goChecks.ruleKey(check);
            Objects.requireNonNull(ruleKey);
            check.initialize(new ContextAdapter(ruleKey));
        }
    }

    public class ContextAdapter
    implements InitContext,
    CheckContext {
        public final RuleKey ruleKey;
        private InputFileContext currentCtx;
        private GoModFileData currentGoModFileData;

        public ContextAdapter(RuleKey ruleKey) {
            this.ruleKey = ruleKey;
        }

        @Override
        public GoModFileData goModFileData() {
            return this.currentGoModFileData;
        }

        @Override
        public <T extends Tree> void register(Class<T> cls, BiConsumer<CheckContext, T> visitor) {
            ChecksVisitor.this.register(cls, ChecksVisitor.this.statistics.time(this.ruleKey.rule(), (ctx, tree) -> {
                this.currentCtx = ctx;
                this.currentGoModFileData = ChecksVisitor.this.goModFileDataStore.retrieveClosestGoModFileData(this.currentCtx.inputFile.uri());
                visitor.accept(this, tree);
            }));
        }

        @Override
        public void registerOnLeave(BiConsumer<CheckContext, Tree> visitor) {
            ChecksVisitor.this.registerOnLeaveTree(TopLevelTree.class, ChecksVisitor.this.statistics.time(this.ruleKey.rule(), (ctx, tree) -> {
                this.currentCtx = ctx;
                visitor.accept(this, (Tree)tree);
            }));
        }

        @Override
        public Deque<Tree> ancestors() {
            return this.currentCtx.ancestors();
        }

        @Override
        public String filename() {
            return this.currentCtx.inputFile.filename();
        }

        @Override
        public InputFile inputFile() {
            return this.currentCtx.inputFile;
        }

        @Override
        public String fileContent() {
            try {
                return this.currentCtx.inputFile.contents();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read content of " + String.valueOf(this.currentCtx.inputFile), e);
            }
        }

        @Override
        public void reportIssue(TextRange textRange, String message) {
            this.reportIssue(textRange, message, Collections.emptyList(), null);
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message) {
            this.reportIssue(toHighlight, message, Collections.emptyList());
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, SecondaryLocation secondaryLocation) {
            this.reportIssue(toHighlight, message, Collections.singletonList(secondaryLocation));
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, List<SecondaryLocation> secondaryLocations) {
            this.reportIssue(toHighlight, message, secondaryLocations, null);
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, List<SecondaryLocation> secondaryLocations, @Nullable Double gap) {
            this.reportIssue(toHighlight.textRange(), message, secondaryLocations, gap);
        }

        @Override
        public void reportFileIssue(String message) {
            this.reportFileIssue(message, null);
        }

        @Override
        public void reportFileIssue(String message, @Nullable Double gap) {
            this.reportIssue((TextRange)null, message, Collections.emptyList(), gap);
        }

        private void reportIssue(@Nullable TextRange textRange, String message, List<SecondaryLocation> secondaryLocations, @Nullable Double gap) {
            this.currentCtx.reportIssue(this.ruleKey, textRange, message, secondaryLocations, gap);
        }
    }
}

