/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.persistence.conversion;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.go.impl.FunctionDeclarationTreeImpl;
import org.sonar.go.impl.TreeMetaDataProvider;
import org.sonar.go.impl.cfg.BlockImpl;
import org.sonar.go.impl.cfg.ControlFlowGraphImpl;
import org.sonar.go.persistence.conversion.PolymorphicConverter;
import org.sonar.go.persistence.conversion.RangeConverter;
import org.sonar.go.persistence.conversion.StringNativeKind;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.NativeKind;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeMetaData;
import org.sonar.plugins.go.api.cfg.Block;
import org.sonar.plugins.go.api.cfg.ControlFlowGraph;

public class DeserializationContext {
    private static final Logger LOG = LoggerFactory.getLogger(DeserializationContext.class);
    private static final int MAX_ILLEGAL_ELEMENT_TEXT_LENGTH = 80;
    private final PolymorphicConverter polymorphicConverter;
    private final Deque<String> jsonPath = new LinkedList<String>();
    private final Map<Integer, Tree> cfgIndexToTree = new HashMap<Integer, Tree>();
    private TreeMetaDataProvider metaDataProvider = null;

    public DeserializationContext(PolymorphicConverter polymorphicConverter) {
        this.polymorphicConverter = polymorphicConverter;
    }

    public DeserializationContext withMetaDataProvider(TreeMetaDataProvider metaDataProvider) {
        this.metaDataProvider = metaDataProvider;
        return this;
    }

    public void pushPath(String fieldName) {
        this.jsonPath.addLast(fieldName);
    }

    public void popPath() {
        this.jsonPath.removeLast();
    }

    public String path() {
        return String.join((CharSequence)"/", this.jsonPath);
    }

    public TreeMetaData metaData(JsonObject json) {
        return RangeConverter.resolveMetaData(this.metaDataProvider, this.fieldToString(json, "metaData"));
    }

    public RuntimeException newIllegalMemberException(String message, @Nullable Object illegalElement) {
        String elementText = String.valueOf(illegalElement);
        elementText = elementText.substring(0, Math.min(elementText.length(), 80));
        return new IllegalStateException(message + " at '" + this.path() + "' member: " + elementText);
    }

    @Nullable
    public <T extends Tree> T fieldToNullableObject(JsonObject parent, String fieldName, Class<T> expectedClass) {
        JsonValue json = parent.get(fieldName);
        if (json == null || Json.NULL.equals(json)) {
            return null;
        }
        return this.object(json, fieldName, expectedClass);
    }

    public <T extends Tree> T fieldToObject(JsonObject parent, String fieldName, Class<T> expectedClass) {
        JsonValue json = parent.get(fieldName);
        if (json == null || Json.NULL.equals(json)) {
            throw this.newIllegalMemberException("Unexpected null value for field '" + fieldName + "'", json);
        }
        return this.object(json, fieldName, expectedClass);
    }

    public NativeKind fieldToNativeKind(JsonObject parent, String fieldName) {
        return StringNativeKind.of(this.fieldToString(parent, fieldName, ""));
    }

    public <T extends Enum<T>> T fieldToEnum(JsonObject parent, String fieldName, Class<T> enumType) {
        return Enum.valueOf(enumType, this.fieldToString(parent, fieldName));
    }

    public <T extends Enum<T>> T fieldToEnum(JsonObject parent, String fieldName, String defaultValue, Class<T> enumType) {
        return Enum.valueOf(enumType, this.fieldToString(parent, fieldName, defaultValue));
    }

    public <T extends Tree> List<T> fieldToObjectList(JsonObject parent, String fieldName, Class<T> expectedClass) {
        return this.objectList(parent.get(fieldName), fieldName + "[]", expectedClass);
    }

    public <T extends Tree> List<T> objectList(@Nullable JsonValue value, String memberName, Class<T> expectedClass) {
        return this.objectList(value, (JsonObject jsonChild) -> this.object((JsonValue)jsonChild, memberName, expectedClass));
    }

    public <T> List<T> objectList(@Nullable JsonValue value, BiFunction<DeserializationContext, JsonObject, T> converter) {
        return this.objectList(value, (JsonObject jsonChild) -> converter.apply(this, (JsonObject)jsonChild));
    }

    private <T> List<T> objectList(@Nullable JsonValue value, Function<JsonObject, T> converter) {
        if (value == null || value.isNull()) {
            return Collections.emptyList();
        }
        if (!value.isArray()) {
            throw this.newIllegalMemberException("Expect Array instead of " + value.getClass().getSimpleName(), value);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (JsonValue jsonValue : value.asArray()) {
            result.add(converter.apply(jsonValue.asObject()));
        }
        return result;
    }

    public <T> List<T> stringList(@Nullable JsonValue value, BiFunction<DeserializationContext, String, T> converter) {
        return this.stringList(value, (String jsonChild) -> converter.apply(this, (String)jsonChild));
    }

    private <T> List<T> stringList(@Nullable JsonValue value, Function<String, T> converter) {
        if (value == null || value.isNull()) {
            return Collections.emptyList();
        }
        if (!value.isArray()) {
            throw this.newIllegalMemberException("Expect Array instead of " + value.getClass().getSimpleName(), value);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (JsonValue jsonValue : value.asArray()) {
            result.add(converter.apply(jsonValue.asString()));
        }
        return result;
    }

    public String fieldToNullableString(JsonObject json, String fieldName) {
        JsonValue value = json.get(fieldName);
        if (value == null || Json.NULL.equals(value)) {
            return null;
        }
        return this.fieldToString(json, fieldName);
    }

    public String fieldToString(JsonObject json, String fieldName) {
        JsonValue value = json.get(fieldName);
        if (value == null || Json.NULL.equals(value)) {
            throw this.newIllegalMemberException("Missing non-null value for field '" + fieldName + "'", json);
        }
        if (!value.isString()) {
            throw this.newIllegalMemberException("Expect String instead of '" + value.getClass().getSimpleName() + "' for field '" + fieldName + "'", json);
        }
        return value.asString();
    }

    public String fieldToString(JsonObject json, String fieldName, String defaultValue) {
        return json.getString(fieldName, defaultValue);
    }

    public int fieldToInt(JsonObject json, String fieldName) {
        JsonValue value = json.get(fieldName);
        if (value == null || Json.NULL.equals(value)) {
            throw this.newIllegalMemberException("Missing non-null value for field '" + fieldName + "'", json);
        }
        if (!value.isNumber()) {
            throw this.newIllegalMemberException("Expect Number instead of '" + value.getClass().getSimpleName() + "' for field '" + fieldName + "'", json);
        }
        return value.asInt();
    }

    public TextRange fieldToRange(JsonObject json, String fieldName) {
        return RangeConverter.parse(this.fieldToString(json, fieldName));
    }

    public Token fieldToToken(JsonObject json, String fieldName) {
        return RangeConverter.resolveToken(this.metaDataProvider, this.fieldToString(json, fieldName));
    }

    @Nullable
    public Token fieldToNullableToken(JsonObject json, String fieldName) {
        return RangeConverter.resolveToken(this.metaDataProvider, this.fieldToNullableString(json, fieldName));
    }

    private <T extends Tree> T object(JsonValue json, String memberName, Class<T> expectedClass) {
        this.pushPath(memberName);
        if (!json.isObject()) {
            throw this.newIllegalMemberException("Unexpected value for Tree", json);
        }
        JsonObject jsonObject = json.asObject();
        String jsonType = this.fieldToString(jsonObject, "@type");
        Tree object = (Tree)this.polymorphicConverter.fromJson(this, jsonType, jsonObject, memberName, expectedClass);
        this.popPath();
        int cfgId = jsonObject.getInt("__cfgId", -1);
        if (cfgId >= 0) {
            this.cfgIndexToTree.put(cfgId, object);
        }
        return (T)object;
    }

    public FunctionDeclarationTreeImpl functionDeclarationTree(JsonObject json) {
        Tree returnType = this.fieldToNullableObject(json, "returnType", Tree.class);
        Tree receiver = this.fieldToNullableObject(json, "receiver", Tree.class);
        IdentifierTree name = this.fieldToNullableObject(json, "name", IdentifierTree.class);
        List<Tree> formalParameters = this.fieldToObjectList(json, "formalParameters", Tree.class);
        Tree typeParameters = this.fieldToNullableObject(json, "typeParameters", Tree.class);
        BlockTree body = this.fieldToNullableObject(json, "body", BlockTree.class);
        ControlFlowGraph cfg = this.controlFlowGraph(json);
        return new FunctionDeclarationTreeImpl(this.metaData(json), returnType, receiver, name, formalParameters, typeParameters, body, cfg);
    }

    @CheckForNull
    public ControlFlowGraph controlFlowGraph(JsonObject json) {
        try {
            JsonValue cfgValue = json.get("cfg");
            if (cfgValue == null || !cfgValue.isObject()) {
                return null;
            }
            JsonObject cfgObject = cfgValue.asObject();
            JsonValue blocksValue = cfgObject.get("Blocks");
            if (!blocksValue.isArray()) {
                return null;
            }
            List<JsonObject> blocks = blocksValue.asArray().values().stream().filter(JsonValue::isObject).map(JsonValue::asObject).toList();
            ArrayList<Block> mappedBlocks = new ArrayList<Block>();
            for (JsonObject block : blocks) {
                JsonValue node = block.get("Node");
                List<Tree> nodes = Collections.emptyList();
                if (node.isArray()) {
                    nodes = node.asArray().values().stream().filter(JsonValue::isNumber).map(JsonValue::asInt).map(this.cfgIndexToTree::get).filter(Objects::nonNull).toList();
                }
                mappedBlocks.add(new BlockImpl(nodes));
            }
            for (int i = 0; i < blocks.size(); ++i) {
                JsonObject currentBlock = blocks.get(i);
                JsonValue successorValue = currentBlock.get("Successors");
                if (!successorValue.isArray()) {
                    ((BlockImpl)mappedBlocks.get(i)).setSuccessors(Collections.emptyList());
                    continue;
                }
                List<Block> successors = successorValue.asArray().values().stream().filter(JsonValue::isNumber).map(JsonValue::asInt).map(mappedBlocks::get).filter(Objects::nonNull).toList();
                ((BlockImpl)mappedBlocks.get(i)).setSuccessors(successors);
            }
            return new ControlFlowGraphImpl(mappedBlocks);
        }
        catch (Exception e) {
            LOG.warn("Error while transferring a CFG.", (Throwable)e);
            return null;
        }
    }
}

