/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.persistence;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.sonar.go.impl.TreeMetaDataProvider;
import org.sonar.go.persistence.conversion.DeserializationContext;
import org.sonar.go.persistence.conversion.JsonTreeConverter;
import org.sonar.go.persistence.conversion.SerializationContext;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeMetaData;
import org.sonar.plugins.go.api.TreeOrError;

public final class JsonTree {
    private JsonTree() {
    }

    public static String toJson(Tree tree) {
        TreeMetaData metaData = tree.metaData();
        TreeMetaDataProvider provider = new TreeMetaDataProvider(metaData.commentsInside(), metaData.tokens());
        SerializationContext ctx = new SerializationContext(JsonTreeConverter.POLYMORPHIC_CONVERTER);
        return Json.object().add("treeMetaData", (JsonValue)JsonTreeConverter.TREE_METADATA_PROVIDER_TO_JSON.apply((TreeMetaDataProvider)((Object)ctx), provider)).add("tree", ctx.toJson(tree)).toString();
    }

    public static Tree fromJsonSingleTree(String json) {
        JsonObject root = Json.parse(json).asObject();
        return JsonTree.fromJsonSingleTree(root);
    }

    private static Tree fromJsonSingleTree(JsonObject root) {
        JsonObject treeMetaData = root.get("treeMetaData").asObject();
        DeserializationContext ctx = new DeserializationContext(JsonTreeConverter.POLYMORPHIC_CONVERTER);
        TreeMetaDataProvider metaDataProvider = (TreeMetaDataProvider)JsonTreeConverter.TREE_METADATA_PROVIDER_FROM_JSON.apply((TreeMetaDataProvider)((Object)ctx), treeMetaData);
        ctx = ctx.withMetaDataProvider(metaDataProvider);
        return ctx.fieldToNullableObject(root, "tree", Tree.class);
    }

    public static Map<String, TreeOrError> fromJson(String json) {
        HashMap<String, TreeOrError> trees = new HashMap<String, TreeOrError>();
        JsonObject root = Json.parse(json).asObject();
        for (String name : root.names()) {
            JsonObject treeRoot = root.get(name).asObject();
            JsonValue errorJson = treeRoot.get("error");
            if (errorJson != null && errorJson.isString()) {
                String errorMessage = errorJson.asString();
                trees.put(name, TreeOrError.of(errorMessage));
                continue;
            }
            try {
                Tree tree = JsonTree.fromJsonSingleTree(treeRoot);
                trees.put(name, TreeOrError.of(tree));
            }
            catch (RuntimeException e) {
                trees.put(name, TreeOrError.of("Error converting json tree: " + e.getMessage()));
            }
        }
        return trees;
    }
}

