/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.impl;

import org.sonar.plugins.go.api.Type;

public class TypeImpl
implements Type {
    public static final Type UNKNOWN_TYPE = new TypeImpl("UNKNOWN", "UNKNOWN");
    private final String type;
    private final String packageName;

    public TypeImpl(String type, String packageName) {
        this.type = type;
        this.packageName = packageName;
    }

    public static TypeImpl createFromType(String text) {
        int index = text.lastIndexOf(".");
        String packageName = "";
        if (index != -1) {
            packageName = text.substring(0, index);
        }
        if (packageName.startsWith("&") || packageName.startsWith("*")) {
            packageName = packageName.substring(1);
        }
        return new TypeImpl(text, packageName);
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String packageName() {
        return this.packageName;
    }

    @Override
    public boolean isTypeOf(String baseType) {
        return baseType.equals(this.extractBaseType());
    }

    private String extractBaseType() {
        if (this.type.startsWith("&") || this.type.startsWith("*")) {
            return this.type.substring(1);
        }
        return this.type;
    }
}

