/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.go.impl.BaseTreeImpl;
import org.sonar.plugins.go.api.Comment;
import org.sonar.plugins.go.api.ImportDeclarationTree;
import org.sonar.plugins.go.api.ImportSpecificationTree;
import org.sonar.plugins.go.api.PackageDeclarationTree;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeMetaData;

public class TopLevelTreeImpl
extends BaseTreeImpl
implements TopLevelTree {
    private final List<Tree> declarations;
    private final List<Comment> allComments;
    private final Token firstCpdToken;
    private final Set<String> importsAsStrings;

    public TopLevelTreeImpl(TreeMetaData metaData, List<Tree> declarations, List<Comment> allComments) {
        this(metaData, declarations, allComments, null);
    }

    public TopLevelTreeImpl(TreeMetaData metaData, List<Tree> declarations, List<Comment> allComments, @Nullable Token firstCpdToken) {
        super(metaData);
        this.declarations = declarations;
        this.allComments = allComments;
        this.firstCpdToken = firstCpdToken;
        this.importsAsStrings = TopLevelTreeImpl.getImportsAsStrings(declarations);
    }

    @Override
    public List<Tree> declarations() {
        return this.declarations;
    }

    @Override
    public List<Comment> allComments() {
        return this.allComments;
    }

    @Override
    @CheckForNull
    public Token firstCpdToken() {
        return this.firstCpdToken;
    }

    @Override
    public List<Tree> children() {
        return this.declarations();
    }

    @Override
    public boolean doesImportType(String type) {
        return this.importsAsStrings.contains(type);
    }

    @Override
    public String packageName() {
        return this.descendants().filter(PackageDeclarationTree.class::isInstance).map(PackageDeclarationTree.class::cast).findFirst().map(PackageDeclarationTree::packageName).orElse("");
    }

    private static Set<String> getImportsAsStrings(List<Tree> declarations) {
        return declarations.stream().filter(ImportDeclarationTree.class::isInstance).flatMap(it -> it.children().stream()).filter(ImportSpecificationTree.class::isInstance).map(ImportSpecificationTree.class::cast).filter(spec -> spec.name() == null).map(spec -> spec.path().content()).collect(Collectors.toSet());
    }
}

