/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.go.impl.BaseTreeImpl;
import org.sonar.go.impl.TextRanges;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.MatchCaseTree;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeMetaData;

public class MatchCaseTreeImpl
extends BaseTreeImpl
implements MatchCaseTree {
    private final Tree expression;
    private final Tree body;

    public MatchCaseTreeImpl(TreeMetaData metaData, @Nullable Tree expression, @Nullable Tree body) {
        super(metaData);
        this.expression = expression;
        this.body = body;
    }

    @Override
    @CheckForNull
    public Tree expression() {
        return this.expression;
    }

    @Override
    @CheckForNull
    public Tree body() {
        return this.body;
    }

    @Override
    public TextRange rangeToHighlight() {
        if (this.body == null) {
            return this.textRange();
        }
        TextRange bodyRange = this.body.metaData().textRange();
        List<TextRange> tokenRangesBeforeBody = this.metaData().tokens().stream().map(HasTextRange::textRange).filter(t -> t.start().compareTo(bodyRange.start()) < 0).toList();
        if (tokenRangesBeforeBody.isEmpty()) {
            return bodyRange;
        }
        return TextRanges.merge(tokenRangesBeforeBody);
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        if (this.expression != null) {
            children.add(this.expression);
        }
        if (this.body != null) {
            children.add(this.body);
        }
        return children;
    }
}

